/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "cuboid.h" // class's header file

Cuboid::Cuboid(char* body_name, char * pos_file): CRigidBody( body_name, pos_file), Contour_List(0)
{
   strcpy(body_file_name,body_name);
   strcpy(posfile_name , pos_file);
   float* tempfloat;
   int result;
   cuboid_data_struct* vertex_data;
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&cuboid_width);
   parsenextdataline(datafile);

   result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&cuboid_height);
   parsenextdataline(datafile);

   result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&cuboid_size);
   parsenextdataline(datafile);



    vertex_data = new cuboid_data_struct;
    tempfloat = new float[3];
    tempfloat[X]=-cuboid_width/2.0;
    tempfloat[Y]= cuboid_height/2.0;
    tempfloat[Z]= 0.0;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 1;   
    CuboidVector.push_back(vertex_data);  
      
    vertex_data = new cuboid_data_struct;
    tempfloat = new float[3];
    tempfloat[X]=cuboid_width/2.0;
    tempfloat[Y]= cuboid_height/2.0;
    tempfloat[Z]= 0.0 ;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 1;   
    CuboidVector.push_back(vertex_data);  

   
    vertex_data = new cuboid_data_struct;
    tempfloat = new float[3];
    tempfloat[X]= cuboid_width/2.0;
    tempfloat[Y]= -cuboid_height/2.0;
    tempfloat[Z]= 0.0 ;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 1;   
    CuboidVector.push_back(vertex_data); 
   
    vertex_data = new cuboid_data_struct;
    tempfloat = new float[3];
    tempfloat[X]=-cuboid_width/2.0;
    tempfloat[Y]=-cuboid_height/2.0;
    tempfloat[Z]= 0.0 ;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 1;   
    CuboidVector.push_back(vertex_data);  

    vertex_data = new cuboid_data_struct;
    tempfloat = new float[3];
    tempfloat[X]=-cuboid_width/2.0;
    tempfloat[Y]= cuboid_height/2.0;
    tempfloat[Z]= 0.0;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 1;   
    CuboidVector.push_back(vertex_data);  

}

Cuboid::Cuboid(FILE *bodyfile): CRigidBody(bodyfile), Contour_List(0)
{
   float* tempfloat;
   int result;
   cuboid_data_struct* vertex_data;
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&cuboid_width);
   parsenextdataline(datafile);

   result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&cuboid_height);
   parsenextdataline(datafile);

   result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&cuboid_size);
   parsenextdataline(datafile);



    vertex_data = new cuboid_data_struct;
    tempfloat = new float[3];
    tempfloat[X]=-cuboid_width/2.0;
    tempfloat[Y]= cuboid_height/2.0;
    tempfloat[Z]= 0.0;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 1;   
    CuboidVector.push_back(vertex_data);  
      
    vertex_data = new cuboid_data_struct;
    tempfloat = new float[3];
    tempfloat[X]=cuboid_width/2.0;
    tempfloat[Y]= cuboid_height/2.0;
    tempfloat[Z]= 0.0 ;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 1;   
    CuboidVector.push_back(vertex_data);  

   
    vertex_data = new cuboid_data_struct;
    tempfloat = new float[3];
    tempfloat[X]= cuboid_width/2.0;
    tempfloat[Y]= -cuboid_height/2.0;
    tempfloat[Z]= 0.0 ;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 1;   
    CuboidVector.push_back(vertex_data); 
   
    vertex_data = new cuboid_data_struct;
    tempfloat = new float[3];
    tempfloat[X]=-cuboid_width/2.0;
    tempfloat[Y]=-cuboid_height/2.0;
    tempfloat[Z]= 0.0 ;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 1;   
    CuboidVector.push_back(vertex_data);  

    vertex_data = new cuboid_data_struct;
    tempfloat = new float[3];
    tempfloat[X]=-cuboid_width/2.0;
    tempfloat[Y]= cuboid_height/2.0;
    tempfloat[Z]= 0.0;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 1;   
    CuboidVector.push_back(vertex_data);  

}



// class destructor
Cuboid::~Cuboid()
{
}

void Cuboid::init()
{
   CRigidBody::init();
   float minmax[3];
   minmax[0] = cuboid_width / 2.0;
   minmax[1] = cuboid_height / 2.0;
   minmax[2] = -cuboid_size;
   updateminmax(minmax) ;
   minmax[0] = -cuboid_width / 2.0;
   minmax[1] = -cuboid_height / 2.0;
   minmax[2] = 0;
   updateminmax(minmax) ;
   if (Displ_List) glDeleteLists(Displ_List, 1);
   Displ_List = glGenLists(1);
   glNewList(Displ_List, GL_COMPILE);
   
   double x=cuboid_width, y=cuboid_height, z=cuboid_size;
   glBegin(GL_QUADS);
     glNormal3f(0,0,1);
     glVertex3f(-x/2,-y/2,0);
     glVertex3f(x/2,-y/2,0);
     glVertex3f(x/2,y/2,0);
     glVertex3f(-x/2,y/2,0);
     glNormal3f(0,0,1);
     glVertex3f(-x/2,-y/2,-z);
     glVertex3f(x/2,-y/2,-z);
     glVertex3f(x/2,y/2,-z);
     glVertex3f(-x/2,y/2,-z);
     glNormal3f(0,-1,0);
     glVertex3f(-x/2,-y/2,-z);
     glVertex3f(x/2,-y/2,-z);
     glVertex3f(x/2,-y/2,0);
     glVertex3f(-x/2,-y/2,0);
     glNormal3f(0,-1,0);
     glVertex3f(-x/2,y/2,-z);
     glVertex3f(x/2,y/2,-z);
     glVertex3f(x/2,y/2,0);
     glVertex3f(-x/2,y/2,0);
     glNormal3f(1,0,0);
     glVertex3f(x/2,-y/2,-z);
     glVertex3f(x/2,y/2,-z);
     glVertex3f(x/2,y/2,0);
     glVertex3f(x/2,-y/2,0);
     glNormal3f(1,0,0);
     glVertex3f(-x/2,-y/2,-z);
     glVertex3f(-x/2,y/2,-z);
     glVertex3f(-x/2,y/2,0);
     glVertex3f(-x/2,-y/2,0);
   glEnd();
   
   glEndList();
}

void Cuboid::draw_contour()
{
   glEnable(GL_POLYGON_OFFSET_LINE);
   glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEnable(GL_COLOR_MATERIAL);
   glLineWidth(1.0);
   glPolygonOffset(OFFSETFAC1,OFFSETUNIT1);
   glDisable(GL_LIGHTING);
   glEnable(GL_LINE_SMOOTH);
   glColor3f(0.0, 0.0, 0.0);
   glCallList(Displ_List);
   glPolygonOffset(0.0,0.0);
   glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
   glDisable(GL_POLYGON_OFFSET_LINE);
}



