/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef Cuboid_H
#define Cuboid_H

#include "crigidbody.h"// inheriting class's header file

struct cuboid_data_struct {
   float* vertex_points;
   int border_flag;
};

// No description
class Cuboid : public CRigidBody
{
public:
   // class constructor
   Cuboid(char* body_name, char * pos_file);
   Cuboid(FILE *bodyfile);
   ~Cuboid();
   virtual void init();
   virtual void draw_contour();
   float cuboid_width;
   float cuboid_height;
   float cuboid_size;
   GLuint  Contour_List;
   std::vector <cuboid_data_struct*> CuboidVector;
   std::vector <cuboid_data_struct*>::iterator CuboidVectorIterator;

};

#endif // Cuboid_H
