/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "cylinder.h" // class's header file

// class constructor
Cylinder::Cylinder(char* body_name, char * pos_file): CRigidBody( body_name,  pos_file)
{
  strcpy(body_file_name,body_name);
  strcpy(posfile_name , pos_file);
  int result;
  char* charstringline = new char [charlength];
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&base);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&top);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&height);
  parsenextdataline(datafile);
  int result1 = GetCharacterLine(charstringline, charlength, datafile);
  int s1 = sscanf(charstringline, "%f \n" ,&InnerRadiusBase);
  parsenextdataline(datafile);
  int result2 = GetCharacterLine(charstringline, charlength, datafile);
  int s2 = sscanf(charstringline, "%f \n" ,&InnerRadiusTop);
  if ((result1<=0) || (result2<=0) || (s1<=0) || (s2<=0)) {
    InnerRadiusBase =0.0;
    InnerRadiusTop  =0.0;
  } 
}

Cylinder::Cylinder(FILE *bodyfile): CRigidBody(bodyfile)
{
   int result;
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&base);
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&top);
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&height);
  parsenextdataline(datafile);
  int result1 = GetCharacterLine(charstringline, charlength, datafile);
  int s1 = sscanf(charstringline, "%f \n" ,&InnerRadiusBase);
  parsenextdataline(datafile);
  int result2 = GetCharacterLine(charstringline, charlength, datafile);
  int s2 = sscanf(charstringline, "%f \n" ,&InnerRadiusTop);
  if ((result1<=0) || (result2<=0) || (s1<=0) || (s2<=0)) {
    InnerRadiusBase =0.0;
    InnerRadiusTop  =0.0;
  } 
}

Cylinder::~Cylinder()
{
}

void Cylinder::init()
{
   CRigidBody::init();
   float minmax[3];
   float max_cyl;
 	
   if(base > top) 
   max_cyl=base; else max_cyl=top;
   GLUquadricObj *quadObj;
   quadObj = gluNewQuadric();
   gluQuadricDrawStyle(quadObj, GLU_FILL);

   minmax[0] = max_cyl;
   minmax[1] = 0.0;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0;
   minmax[1] = max_cyl;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0;
   minmax[1] = -max_cyl;
   minmax[2] = 0.0;
   updateminmax(minmax); 
   minmax[0] = -max_cyl;
   minmax[1] = 0.0;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = max_cyl;
   minmax[1] = 0.0;
   minmax[2] = -height;
   updateminmax(minmax) ;
   minmax[0] = 0.0;
   minmax[1] = max_cyl;
   minmax[2] =-height;
   updateminmax(minmax) ;
   minmax[0] = 0.0;
   minmax[1] = -max_cyl;
   minmax[2] =-height;
   updateminmax(minmax); 
   minmax[0] = -max_cyl;
   minmax[1] = 0.0;
   minmax[2] = -height;
   updateminmax(minmax) ;
   if (Displ_List) glDeleteLists(Displ_List, 1);
   Displ_List = glGenLists(1);
   glNewList(Displ_List, GL_COMPILE);
   if (InnerRadiusTop) gluPartialDisk(quadObj, InnerRadiusTop, top, NCIRCLE(top),5, 0, 360);
   else Circle(top, 0, 360, false);
   glPushMatrix();
   glTranslatef(0.0, 0.0, -height);
   gluCylinder(quadObj, base,  top, height, NCIRCLE(fmax(base,top)), 1);
   if ((InnerRadiusTop)||(InnerRadiusBase))
     gluCylinder(quadObj, InnerRadiusBase,  InnerRadiusTop, height, NCIRCLE(fmax(base,top)), 1);
   if (InnerRadiusBase) gluPartialDisk(quadObj, InnerRadiusBase, base, NCIRCLE(base),5, 0, 360);
   else Circle(base, 0, 360, true);   
glPopMatrix();
   glEndList();

}

void Cylinder::draw_contour()
{
   glEnable(GL_POLYGON_OFFSET_LINE);
   glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEnable(GL_COLOR_MATERIAL);
   glLineWidth(1.0);
   glPolygonOffset(OFFSETFAC1,OFFSETUNIT1);
   glDisable(GL_LIGHTING);
   glEnable(GL_LINE_SMOOTH);
   glColor3f(0.0, 0.0, 0.0);
   Circle_Line(top);
   if (InnerRadiusTop) Circle_Line(InnerRadiusTop);
   glPushMatrix();
   glTranslatef(0.0, 0.0, -height);
   Circle_Line(base);
   if (InnerRadiusBase) Circle_Line(InnerRadiusBase);
   glPopMatrix();

   glPolygonOffset(0.0,0.0);
   glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
   glDisable(GL_POLYGON_OFFSET_LINE);
}
