/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <deflectionline.h>

// Destructor
DeflectionLine::DeflectionLine(char* body_name, char *pos_file) : CBody(body_name, pos_file) {
  int result;
  char* charstringline = new char [charlength];

  parsenextdataline(datafile);
  result=GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%d" ,&num);
  binaryrecordsize=sizeof(float)*num;
  w=new float[num];

  parsenextdataline(datafile);
  result=GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f" ,&dx);

  parsenextdataline(datafile);
  result=GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f" ,&scale);
}

// Destructor
DeflectionLine::~DeflectionLine() {
}

void DeflectionLine::drawBody() {
  glBegin(GL_LINE_STRIP);
    for(int i=0; i<num; i++)
      glVertex3f(i*dx, w[i]*scale, 0);
  glEnd();
}

// Draw body
void DeflectionLine::draw() {
  glDisable(GL_COLOR_MATERIAL);
  glEnable(GL_LIGHTING);
  GLfloat color[] = {0.0, 0.0, 1.0, 1.0 };
  glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, color);
  GLfloat mat_specular[] = {1.0, 1.0, 1.0, 1.0};
  glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, mat_specular);
  float color_shininess=20;
  glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, &color_shininess);
  float em[4]={0,0,0,0};
  glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, em);

  glPushMatrix();

  if(mode==0) glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  if(mode==1) glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
  if(mode==2) glPolygonMode(GL_FRONT_AND_BACK, GL_POINT);

  drawBodyFast(); // this calls "virtual void drawBody()" in a very fast way if possible!
  
  if(contour_flag==true) {
    // draw contour
    glEnable(GL_POLYGON_OFFSET_LINE);
    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
    glEnable(GL_COLOR_MATERIAL);
    glLineWidth(1.0);
    glPolygonOffset(OFFSETFAC1,OFFSETUNIT1);
    glDisable(GL_LIGHTING);
    glEnable(GL_LINE_SMOOTH);
    glColor3f(0.0, 0.0, 0.0);
    drawBodyFast(); // this calls "virtual void drawBody()" in a very fast way if possible!
  }
  
  if(selected_flag==true) {
    // draw something
  }
  
  if(local_cos_flag==true) {
    // draw something
  }

  glPopMatrix();
}

// Initialize (Call CBody::init()!)
void DeflectionLine::init() {
  CBody::init();
}

// Read data from pos-file
void DeflectionLine::update(long dataset_number) {
  fseek(posfile_pointer, dataset_number*recordsize, SEEK_SET);
  if(pos_file_binary==true) {
    float *dummy=new float[num+1];
    fread(dummy,sizeof(float),num+1,posfile_pointer);
    current_time=dummy[0];
    for(int i=0; i<num; i++)
      w[i]=dummy[i+1];
  } else {
    fscanf(posfile_pointer, "%f", &current_time);
    for(int i=0; i<num; i++)
      fscanf(posfile_pointer, "%f", &w[i]);
  }
  curdataset=dataset_number;
}

// For selection by mouse click
void DeflectionLine::draw_pure() {
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  glDisable(GL_LIGHTING);
  glEnable(GL_COLOR_MATERIAL);
  glColor3fv(pick_color_value);
  glPushMatrix();

  drawBodyFast(); // this calls "virtual void drawBody()" in a very fast way if possible!

  glPopMatrix();
  glEnable(GL_LIGHTING);
  glDisable(GL_COLOR_MATERIAL);
}

// Text in the left
void DeflectionLine::return_info_string(QString &info) {
  info=tr("");
}

// For move camera with body (rigid-body movement)
void DeflectionLine::ret_rot(float *rotation) {
  rotation[0]=0;
  rotation[1]=0;
  rotation[2]=0;
}

// For move camera with body (rigid-body movement)
void DeflectionLine::ret_trans(float *translation) {
  translation[0]=0;
  translation[1]=0;
  translation[2]=0;
}

// For move camera with body (rigid-body movement) (Not really needed)
void DeflectionLine::return_max_dimensions(float *min_x, float *max_x, float *min_y, float *max_y, float *min_z, float *max_z) {
  *min_x=0;
  *max_x=0;
  *min_y=0;
  *max_y=0;
  *min_z=0;
  *max_z=0;
}
