/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DRAWOBJECTCONTAINER_H
#define DRAWOBJECTCONTAINER_H

#include <vector>
#include "cbody.h" // class's header file
#include "objobject.h"
#include "ketsim.h"
#include "cube.h"
#include "ketsim_rk_hk_bb.h"
#include "ketsim_rk_hk_nn.h"
#include "ketsim_vz.h"
#include "ketsim_zk_zl.h"
#include "ketsim_ss.h"
#include "ketsim_fs.h"
#include "ketsim_zk_ag_fl1.h"
#include "ketsim_zk_ag_fl2.h" 
#include "cbody.h"
#include "cuboid.h"
#include "torus.h"
#include "kos.h"
#include "cylinder.h"
#include "sphere.h"
#include "invisiblebody.h"
//Roland Zander, Thorsten Schindler
#include "elastic1s21rcm.h"
#include "elastic1s33rcm.h"
#include "elastic1sbta.h"
#include "elastic2s13disk.h"
#include "quad.h"
#include "area.h"
///Roland Zander
#include "compoundprimitivebody.h"
#include "extrusion.h"
#include "rotation.h"
#include "coilspring.h"
// VT
#include "vt_valveseat.h"
#include "vt_valve.h"
#include "vt_rockerarm.h"
// VT

#include <QtGui>
#include <fstream>
#include <iostream>
#include <QDataStream>
#include <QMessageBox>
#include <QFile>
#include <stdio.h>
#include <QDir>
#include <QTextEdit>
#include <QListWidget>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <cstdlib>
#include <math.h>
#include <QTextCursor>
#include <QString>
#include "GL/glu.h"
#include "GL/gl.h"
#include <QTimer>
#include <QtOpenGL>

#define CR 0x0D // Cariage Return
#define LF 0x0A // Line Feed

#define Error_wrong_params (-2)
#define Error_buffertoosmall (-3)
#define Error_readerror (-4)
#define Error_linetoolong (-5)


class QTextEdit;
class QListWidget;
class GLWidget;

class DrawObjectContainer : public QObject
{
Q_OBJECT
public:
   // class constructor
   DrawObjectContainer();
   // class destructor
   ~DrawObjectContainer();
   std::vector <CBody*> OBjectVectorContainer;         //Vector to store CBody
   std::vector <CBody*> BodyEnv;
   QTextEdit *direct_output;
   QListWidget *LeftInfoList;
   void Create();
   void parsenextdataline(FILE * pfilepointer);
   int GetCharacterLine(char *pCharacterLineBuffer, int iBufferSize, FILE *pFile);
   void draw_all_objects();
   void draw_all_objects_pure();
   long return_picked_object( float *picked_color);
   long update_last_position();
   long update_current_position();
   long object_pick_counter;
   float object_time();
   bool total_beginning_flag;
   long beginning_record;
   long get_max_records();
   long get_current_record();
   void set_update_position(long position);
   void get_current_trans(float* return_trans);
   void get_current_rot(float* return_rot);
   int  current_object;
   void get_delta_time(float* deltatime);
   void get_object_info(QString &ob_info);
   void get_object_dimensions(float* minimum_x, float* maximum_x, float* minimum_y, float* maximum_y,float* minimum_z, float* maximum_z);
   void set_current_object(int objectnumber);
   int  get_current_object();
   void get_object_properties(bool* ob_enabled, bool* ob_selected, bool* ob_contour, bool *ob_path, bool* ob_local_cos, int *mode_);
   void set_object_properties(bool ob_enabled, bool ob_selected, bool ob_contour, bool ob_path, bool ob_local_cos);
   void set_draw_mode(int drawmode);
   void setGLWidget(GLWidget *glw) { glWidget=glw; };
 

 private:
   CBody* objectFactory(char *ObjectClassName, char *BodyFileName, char *NewFileEnding);

 public slots:
   void editBody();

 protected:
   GLWidget *glWidget;
};

#endif // DRAWOBJECTCONTAINER_H
