/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _ELASTIC_BODY_H_
#define _ELASTIC_BODY_H_

#include "gle.h"
#include <cbody.h>

class ElasticBody : public CBody
{
public:
   ElasticBody(char* body_name, char *pos_file);
   ~ElasticBody();

   void init();
   void update(long dataset_number);

   virtual void draw();
   virtual void draw_pure() {}

   void ret_rot(float *rotation);
   void ret_trans(float *translation);
   void return_info_string(QString  &info);

protected:
   float* q;
   int dofs;
   int currentFrame;
};

class ElasticBody1s : public ElasticBody
{
 public:
    ElasticBody1s(char* body_name, char *pos_file);
    ~ElasticBody1s();
    
    /*! compute sweep Path; note that first and last point are not drawn but used to define angles, thus arrays are bigger (+2) than discretisation ! */
    virtual void computeSweep(const int discretisation, gleDouble point_array[][3], gleDouble twist_array[]) = 0;
    
    // overload pure virtuals
    void draw();
    void draw_pure();
    
   virtual void edit();

 protected:
    int nContourPoints;
    typedef double SVec[2];
    SVec *cont_normal; /* 2D contour normals */
    SVec *contour;     /* 2D contour */
    gleDouble up[3];   /* up vector for contour */
    
    int discretisation;

    float colorvalue;
    GLfloat color[4];

    void drawBody();
};

#endif
