/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _ELASTIC_BODY_1S_21_RCM_H_
#define _ELASTIC_BODY_1S_21_RCM_H_

#include <elastic.h>

class ElasticBody1s21RCM : public ElasticBody1s
{
public:
   ElasticBody1s21RCM(char* body_name, char *pos_file);
   ~ElasticBody1s21RCM();

   void computeSweep(const int npoints, gleDouble point_array[][3], gleDouble twist_array[]);

   void ret_rot(float *rotation);
   void ret_trans(float *translation);
   void init();
   void return_info_string(QString &info);

protected:
   int nElements;
   bool closed;
   float breite;
   float l0, l0h2, l0h4;
   double lGes, lGesEff, lOffSet;
   float WrN00[3];
   float JT[3][2];
   float    JR[3];

   void LocateStructure(GLdouble *X, const double s);
   void BuildElement(const int& ENumber);
   void LocateBalken(GLdouble *X, const double s);
   void initCoordinates();

 private:
   double qElement[8];
   double Power(double,int);
};

#endif
