/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _ELASTIC_BODY_1S_BTA_H_
#define _ELASTIC_BODY_1S_BTA_H_

#include <elastic.h>

class ElasticBody1sBTA : public ElasticBody1s
{
public:
   ElasticBody1sBTA(char* body_name, char *pos_file);
   ~ElasticBody1sBTA();

   /*! compute poly-line vertices for extrusion */
   void computeSweep(const int npoints, gleDouble point_array[][3], gleDouble twist_array[]);


   void init();
   void return_info_string(QString &info);

protected:
   int nElements;
   float r;
   float l0, l0h2, l0h4;
   double lGes, lOffSet, lGesEff;
   float WrN00[3];
   float J[3][3];

   void LocateStructure(GLdouble *X, const double s);


 private:
   float qElement[10];
   double Power(double,int);
};

#endif
