/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ELASTICBODY_2S_13_DISK_H
#define ELASTICBODY_2S_13_DISK_H

#include <QMessageBox>
#include "elastic.h" // inheriting class's header file

class ElasticBody2s13Disk : public ElasticBody
{
  struct NodeCoordinates {float r; float j;};
  struct ElementNodeList {int node0;int node1;int node2;int node3;};
  private:
    static const int NodeDofs;
	static const int RefDofs;

	GLdouble* position(const double &x, const double &y,int Element);
//	GLdouble* normal  (const double &x, const double &y);

	int nr,nj,Nodes,Elements;
	float Ri,Ra;
	float di[3],da[3];

	float WrN00[3];
	GLfloat *J;
	float Axis[3];

	double NodeRJ0[2];
	double NodeRJ1[2];
	double NodeRJ2[2];
	double NodeRJ3[2];

	NodeCoordinates *NC;
	ElementNodeList *ENL;
  
	int drawPointElement_r,drawPointElement_j;
    double delta_r,delta_j;
    GLuint curDisplListOutline;

  protected:
	float colorvalue;
	GLfloat color[4];

  public:
	// class constructor
	ElasticBody2s13Disk(char* body_name, char * pos_file);
	// class destructor
	~ElasticBody2s13Disk();
	void init();
	void draw();
	void drawBody();
	void drawBodyOutline();
	void draw_pure();

	void ret_trans(float *translation);
	void ret_rot(float *rot);
	void return_info_string(QString &info);
};

#endif // SPHERE_H
