/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "extrusion.h"

using namespace std;

Extrusion::Extrusion(char* body_name, char * pos_file): CRigidBody( body_name,  pos_file), Contour_List(0)
{
  strcpy(body_file_name,body_name);
  strcpy(posfile_name , pos_file);

  char* charstringline = new char [charlength];

  parsenextdataline(datafile);
  GetCharacterLine(charstringline, charlength, datafile);
  char windingstr[charlength];
  sscanf(charstringline, "%s \n", windingstr);
  if(strcmp(windingstr,"ODD")==0) tess_winding=GLU_TESS_WINDING_ODD;
  if(strcmp(windingstr,"NONZERO")==0) tess_winding=GLU_TESS_WINDING_NONZERO;
  if(strcmp(windingstr,"POSITIVE")==0) tess_winding=GLU_TESS_WINDING_POSITIVE;
  if(strcmp(windingstr,"NEGATIVE")==0) tess_winding=GLU_TESS_WINDING_NEGATIVE;
  if(strcmp(windingstr,"ABS_GEQ_TWO")==0) tess_winding=GLU_TESS_WINDING_ABS_GEQ_TWO;

  parsenextdataline(datafile);
  GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&height);

  parsenextdataline(datafile);
  vector<Contour*>* contour;
  Contour *dataset;
  
  contour=new vector<Contour*>;
  contours.push_back(contour);
  do {
    dataset=new Contour;
    fscanf(datafile, "%f %f %d", &dataset->x, &dataset->y, &dataset->b);
    if(dataset->b==-1) break;
    if(dataset->b==-2) {
      contour=new vector<Contour*>;
      contours.push_back(contour);
      continue;
    }
    contour->push_back(dataset);
    float minmax[3];
    minmax[0]=dataset->x;
    minmax[1]=dataset->y;
    minmax[2]=0;
    updateminmax(minmax);
    minmax[2]=height;
    updateminmax(minmax);
  } while(1);

  vector<vector<Contour*>*>::iterator i;
  for(i=contours.begin(); i!=contours.end(); i++)
    **i=recalcContour(**i);
}

Extrusion::Extrusion(FILE *bodyfile): CRigidBody(bodyfile), Contour_List(0)
{
  char* charstringline = new char [charlength];

  parsenextdataline(datafile);
  GetCharacterLine(charstringline, charlength, datafile);
  char windingstr[charlength];
  sscanf(charstringline, "%s \n", windingstr);
  if(strcmp(windingstr,"ODD")==0) tess_winding=GLU_TESS_WINDING_ODD;
  if(strcmp(windingstr,"NONZERO")==0) tess_winding=GLU_TESS_WINDING_NONZERO;
  if(strcmp(windingstr,"POSITIVE")==0) tess_winding=GLU_TESS_WINDING_POSITIVE;
  if(strcmp(windingstr,"NEGATIVE")==0) tess_winding=GLU_TESS_WINDING_NEGATIVE;
  if(strcmp(windingstr,"ABS_GEQ_TWO")==0) tess_winding=GLU_TESS_WINDING_ABS_GEQ_TWO;

  parsenextdataline(datafile);
  GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&height);

  parsenextdataline(datafile);
  vector<Contour*>* contour;
  Contour *dataset;
  
  contour=new vector<Contour*>;
  contours.push_back(contour);
  do {
    dataset=new Contour;
    fscanf(datafile, "%f %f %d", &dataset->x, &dataset->y, &dataset->b);
    if(dataset->b==-1) break;
    if(dataset->b==-2) {
      contour=new vector<Contour*>;
      contours.push_back(contour);
      continue;
    }
    contour->push_back(dataset);
    float minmax[3];
    minmax[0]=dataset->x;
    minmax[1]=dataset->y;
    minmax[2]=0;
    updateminmax(minmax);
    minmax[2]=height;
    updateminmax(minmax);
  } while(1);

  vector<vector<Contour*>*>::iterator i;
  for(i=contours.begin(); i!=contours.end(); i++)
    **i=recalcContour(**i);
}

Extrusion::~Extrusion()
{
}

void Extrusion::init()
{
  CRigidBody::init();

  vector<vector<Contour*>*>::iterator u;
  vector<Contour*>::iterator d;
  gluTessProperty(tobj, GLU_TESS_WINDING_RULE, tess_winding);

  if (Displ_List) glDeleteLists(Displ_List, 1);
  Displ_List=glGenLists(1);
  glNewList(Displ_List, GL_COMPILE);

    glNormal3f(0.0f, 0.0f, -1.0f);
    gluTessBeginPolygon(tobj, NULL);
      for(u=contours.begin(); u!=contours.end(); u++) {
        gluTessBeginContour(tobj);
          for(d=(*u)->begin(); d!=(*u)->end(); d++) {
            GLdouble *vertex=new GLdouble[3];
            vertex[0]=(*d)->x;
            vertex[1]=(*d)->y;
            vertex[2]=0;
            gluTessVertex(tobj, vertex, vertex);
          }
        gluTessEndContour(tobj);
      }
    gluTessEndPolygon(tobj);

    glNormal3f(0.0f, 0.0f, -1.0f);
    gluTessBeginPolygon(tobj, NULL);
      for(u=contours.begin(); u!=contours.end(); u++) {
        gluTessBeginContour(tobj);
          for(d=(*u)->begin(); d!=(*u)->end(); d++) {
            GLdouble *vertex=new GLdouble[3];
            vertex[0]=(*d)->x;
            vertex[1]=(*d)->y;
            vertex[2]=height;
            gluTessVertex(tobj, vertex, vertex);
          }
        gluTessEndContour(tobj);
      }
    gluTessEndPolygon(tobj);

    for(u=contours.begin(); u!=contours.end(); u++) {
      int i,j,k,l;
      for(j=0;j<(int)(*u)->size();j++) {
         i=j-1;
         if(i<0) i+=(*u)->size();
         k=j+1;
         if(k>=(int)(*u)->size()) k-=(*u)->size();
         l=k+1;
         if(l>=(int)(*u)->size()) l-=(*u)->size();
         glBegin(GL_POLYGON);
           if((**u)[j]->b==0)
              glNormal3f(((**u)[k]->y-(**u)[i]->y),
                         ((**u)[i]->x-(**u)[k]->x),0);
           else
              glNormal3f(((**u)[k]->y-(**u)[j]->y),
                         ((**u)[j]->x-(**u)[k]->x),0);
           glVertex3f((**u)[j]->x,(**u)[j]->y,height);
           glVertex3f((**u)[j]->x,(**u)[j]->y, 0.0);
           if((**u)[k]->b==0)
              glNormal3f(((**u)[l]->y-(**u)[j]->y),
                         ((**u)[j]->x-(**u)[l]->x),0);
           else
              glNormal3f(((**u)[k]->y-(**u)[j]->y),
                         ((**u)[j]->x-(**u)[k]->x),0);
 
           glVertex3f((**u)[k]->x,(**u)[k]->y,0.0 );
           glVertex3f((**u)[k]->x,(**u)[k]->y,height);
         glEnd();
      }
    }

  glEndList();

  if(Contour_List) glDeleteLists(Contour_List, 1);
  Contour_List=glGenLists(1);
  glNewList(Contour_List, GL_COMPILE);
    glDisable(GL_LINE_SMOOTH);
    glEnable(GL_COLOR_MATERIAL);
    glLineWidth(1.0);
    glDisable(GL_LIGHTING);
    glColor3f(0.0, 0.0, 0.0);
    for(u=contours.begin(); u!=contours.end(); u++) {
      glBegin(GL_LINE_LOOP);
        for(d=(*u)->begin(); d!=(*u)->end(); d++)
          glVertex3f((*d)->x, (*d)->y, 0);
      glEnd();
      glBegin(GL_LINE_LOOP);
        for(d=(*u)->begin(); d!=(*u)->end(); d++)
          glVertex3f((*d)->x, (*d)->y, height);
      glEnd();
      for(d=(*u)->begin(); d!=(*u)->end(); d++) {
        if((*d)->b==1) {
          glBegin(GL_LINES);
            glVertex3f((*d)->x, (*d)->y, 0);
            glVertex3f((*d)->x, (*d)->y, height);
          glEnd();
        }
      }
    }
  glEndList();
}

void Extrusion::draw_contour()
{
  glCallList(Contour_List);
}
