/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef EXTRUSION_H
#define EXTRUSION_H

#include <QMessageBox>
#include "crigidbody.h" // inheriting class's header file
#include <vector>

class Extrusion : public CRigidBody
{
protected:
  float height;
  int tess_winding;

public:
  Extrusion(char* body_name, char * pos_file);
  Extrusion(FILE *bodyfile);
  ~Extrusion();
  virtual void init();
  virtual void draw_contour();

  std::vector<std::vector<Contour*>*> contours;
  GLuint Contour_List;
};

#endif
