/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef GLWIDGET_H
#define GLWIDGET_H


#include <QtGui>
#include <QtOpenGL>
#include <QMessageBox>
#include <QString>
#include <QMouseEvent>
#include <QPixmap>
#include <QTextStream>
#include <QFile>
#include <QDir>
#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "GL/glu.h"
#include "GL/gl.h"
#include <QTextCursor>
#include <QListWidget>
#include <QTime>
#include <QThread>

#include "drawobjectcontainer.h"
#include "mainwindow.h"

#include <QTimer>
#include <QGLWidget>
#include <QTextCursor>
#include <QSlider>
#include <QLabel>
#include <QSpinBox>
#include <QStatusBar>
#include <QCheckBox>
#include <QImage>




class QTextEdit;
class QTimer;
class QSlider;
class QSpinBox;
class QListWidget;
class QCheckBox;
class QLabel;
class QDoubleSpinBox;
class GLWidget : public QGLWidget
{
   Q_OBJECT

   public:
   GLWidget(QWidget *parent = 0);
   ~GLWidget();
   QTextEdit *direct_output;
   QStatusBar *StatusBar;
   DrawObjectContainer NewGLContainer;
   QSlider * dataset_slider;
   QSpinBox * dataset_spinbox;
   QListWidget* ListBox;
   QCheckBox* EnabledCheckBox;
   QCheckBox* SelectedCheckBox;
   QCheckBox* ContourCheckBox;
   QCheckBox* PathCheckBox;
   QCheckBox* LocalCosCheckBox;
   QCheckBox* OutFileCheckBox;
   QRadioButton *Filled_Radio_Button, *Line_Radio_Button, *Points_Radio_Button;
   QPushButton * LocalCosButton;
   QLabel * TimeSliderLabel;
   QLabel * TimeIntervalLabel;
   QPixmap OutputImage;
   QDoubleSpinBox *TimeSlider;
   float slideshow_time;
   void show_object_info();
   bool follow_object;
   QTime elapsed_system_time;
   void KardanMatrixInvert(float* angles, float  out[16]);
   void HelpDisplay(GLint ww, GLint wh);
   void update_object_properties();
   float delta_object_time;
   int lastr;
   long lastpos_record;
   void write_output_image(QString out_filename);
   QPixmap pixmap;
   QAction *drawWorldCosAct, *drawXYPlaneAct, *drawXZPlaneAct, *drawYZPlaneAct;
   QActionGroup *bg;
   QAction *bgBlack, *bgWhite, *bgColor;

   public slots:
   void write_current_image();
   void look_from_top();
   void look_from_bottom();
   void look_from_right();
   void look_from_left();
   void look_from_front();
   void look_from_back();
   void lastdatapos_timer_slot();
   void slideshow_timer_slot();
   void button_lastpos_slot();
//   void button_slideshow_beginning_slot();
   void button_slideshow_current_slot();
   void dataset_update_position( int value   );
   void dataset_update_position_spinbox( int value   );
   void dataset_update_min_max ()  ;
   void set_slideshow_time( int value   );
   void set_slideshow_time( double value   );
   void listboxclicked();
   void properties_changed();
   void writePixmaps();
   void follow_object_slot();
   void set_mode_filled_slot();
   void set_mode_line_slot();
   void set_mode_point_slot();

   void set_view_state(GLdouble state[16]);//, bool& followObject);
   void get_view_state(GLdouble state[16]);//, bool& followObject);
   void start_auto_play(bool autoPlay);

protected slots:
   void paintGL();
protected:
   void initializeGL();
   void resizeGL(int width, int height);
   void mousePressEvent(QMouseEvent *event);
   void mouseMoveEvent(QMouseEvent *event);
   void draw_background(void);

   QTimer *lastdatapos_timer ;
   QTimer *slideshow_timer ;


private:


   QTimer *glTimer ;

   int xRot;
   int yRot;
   int zRot;

   QPoint lastPos;
   int view_mode;
   GLdouble distance;
   bool lastdatapos_timer_running;
   bool slideshow_timer_running;
   QLabel *fps;
   QTime fpstimer;
   float lastfps;

signals:
   void currentFrame(int);
   void animbuttondown(bool);
   void startvisbuttondown(bool);
   void newAnimSpeed(double);
   void newSliderValue(int);

public slots:
   void setAnimSpeed(int);
   void setSlider(double);

};

#endif
