/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "invisiblebody.h" // class's header file

// class constructor
InvisibleBody::InvisibleBody(char* body_name, char * pos_file): CRigidBody( body_name,  pos_file)
{
   strcpy(body_file_name,body_name);
   strcpy(posfile_name , pos_file);
   int result;
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&Size);
}

InvisibleBody::~InvisibleBody()
{
}

void InvisibleBody::init()
{
   CRigidBody::init();



   float minmax[3];
   minmax[0] = Size ;
   minmax[1] = 0.0;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = -Size ;
   minmax[1] = 0.0;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0 ;
   minmax[1] = Size;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0 ;
   minmax[1] = -Size;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0 ;
   minmax[1] = 0.0;
   minmax[2] = Size;
   updateminmax(minmax) ;
   minmax[0] = 0.0 ;
   minmax[1] = 0.0 ;
   minmax[2] = -Size;
   updateminmax(minmax) ;
}

void InvisibleBody::draw_contour()
{
}
