/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#ifndef KETSIM_H
#define KETSIM_H

#include "GL/glu.h"
#include "GL/gl.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <QMessageBox>
#include <vector>

#include "cbody.h" // inheriting class's header file

// No description
class KetSim : public CBody
{
protected:
  struct vertex_data_struct {
    float *vertex_points;
    int border_flag;
  };

public:
   // class constructor
   KetSim(char* body_name, char * pos_file);
   // class destructor
   ~KetSim();
   // No description
   virtual void draw();
   virtual void read_data();
   GLuint  Displ_List;
   GLuint  Contour_List;

   float angle_alpha;
   // angle beta for the rotation of an object
   float angle_beta;
   // angle gamma for the rotation of an object
   float angle_gamma;
   //the object's positions
   float position_x;
   float position_y;
   float position_z;
   float current_time;
   float x_min, x_max;
   float y_min, y_max;
   float z_min, z_max;
   float scale_factor;
   bool draw_color;

   std::vector <vertex_data_struct*> VertexVector;
   std::vector <vertex_data_struct*>::iterator VertexVectorIterator;

   // Kardan angle transformation matrix
   GLfloat object_rotation_matrix[16];

   GLfloat color[4];
   float   colorvalue;
   GLfloat	color_shininess;
   virtual void updateminmax(float vector[3]);
   virtual void updateminmax(double vector[3]);
   virtual void updateRotationMatrix();
   virtual void update(long dataset_number);
   virtual long get_dataset();
   virtual long get_dataset_last();
   long recordsize;
   bool posfile_ready;
   virtual long getrecordsizetext(FILE * textfilepointer);
   virtual bool getFilePointerandRecSize();
   virtual long getlastposition(FILE * filestream);
   virtual void init();
   GLUtesselator *tobj;
   virtual void ret_time(float* time) ;
   // No description
   virtual void draw_contour() = 0;
   // No description
   virtual void ret_rot(float* rotation) ;
   virtual void ret_trans(float* translation);
   // No description
   virtual void return_max_dimensions(float* min_x, float* max_x, float* min_y, float* max_y,float* min_z, float* max_z);
   virtual void draw_pure();
   void return_info_string(QString &info);


protected:
   float force;
   float   forcemax,forcemin; // minimale/maximale Kraft/Moment/... der Spalte 8
   float force2color(float force);

   static bool initTextures;
   static GLubyte *amlogo[10];
   static int amlogoWH[10];
   std::vector<vertex_data_struct*> recalcContour(std::vector<vertex_data_struct*> &vertex_data);

private:
   float initTransX, initTransY, initTransZ;
   float initRotMatrix[16];
   float initScale;
};

#endif // KETSIM_H
