/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "ketsim_objobject.h"
#include "ketsim.h"
#include <fstream>

KETSIM_ObjObject::KETSIM_ObjObject(char* body_name, char * pos_file): ObjObject(body_name, pos_file) {
   parsenextdataline(datafile);
   fscanf(datafile, "%s", bodyType);

   if(strcmp(bodyType,"KETSIM_FS")==0 ||
      strcmp(bodyType,"KETSIM_SS")==0) {
     std::ifstream minmaxfile("KETSIM_FE.minmax");
     minmaxfile>>forcemin>>forcemax;
     minmaxfile.close();
   }
   if(strcmp(bodyType,"KETSIM_RK_HK_BB")==0 ||
      strcmp(bodyType,"KETSIM_RK_HK_NN")==0) {
     std::ifstream minmaxfile("KETSIM_Gl_RK.minmax");
     minmaxfile>>forcemin>>forcemax;
     minmaxfile.close();
   }
   if(strcmp(bodyType,"KETSIM_VZ")==0) {
     std::ifstream minmaxfile("KETSIM_VZ.minmax");
     minmaxfile>>forcemin>>forcemax;
     minmaxfile.close();
   }
   if(strcmp(bodyType,"KETSIM_ZK_AG_FL1")==0 ||
      strcmp(bodyType,"KETSIM_ZK_AG_FL2")==0) {
     std::ifstream minmaxfile("KETSIM_Gl_ZKFL.minmax");
     minmaxfile>>forcemin>>forcemax;
     minmaxfile.close();
   }
   if(strcmp(bodyType,"KETSIM_ZK_ZL")==0) {
     std::ifstream minmaxfile("KETSIM_Gl_ZKZL.minmax");
     minmaxfile>>forcemin>>forcemax;
     minmaxfile.close();
   }
}

KETSIM_ObjObject::~KETSIM_ObjObject() {
}



void KETSIM_ObjObject::update(long dataset_number)
{
   int erg;
   if (posfile_ready==false)getFilePointerandRecSize();
   if (posfile_ready==true)
   {

      fseek (posfile_pointer, dataset_number * recordsize ,SEEK_SET);
      if (pos_file_binary==false)
      {

	 char szLineBuffer[charlength];
	 erg=GetCharacterLine(szLineBuffer, charlength, posfile_pointer);
	 // QMessageBox::information(NULL, "void CRigidBody::update(long dataset_number)",szLineBuffer);
	 if (erg>0)
	 {
	    sscanf(szLineBuffer, "%f %f %f %f %f %f\n",
		   &current_time,
		   &position_x,
		   &position_y,
		   &position_z,
		   &angle_gamma,
		   &colorvalue);
	    angle_alpha=0;
	    angle_beta=0;
            colorvalue=force2color(colorvalue);
	 };
      }
      else //binary file
      {
	 float tempfloat[6];
	 fread (tempfloat,sizeof(float),6, posfile_pointer);
	 current_time   =tempfloat[0];
	 position_x      =tempfloat[1];
	 position_y  =tempfloat[2];
	 position_z  =tempfloat[3];
	 angle_gamma  =tempfloat[4];
	 colorvalue =tempfloat[5];
	 angle_alpha  =0;
	 angle_beta   =0;
         colorvalue=force2color(colorvalue);
      };//binary file
   };
   curdataset=dataset_number;
}

bool KETSIM_ObjObject::getFilePointerandRecSize()
{
   posfile_ready=true;

   FILE * tempfilepointer;
   if(posfile_pointer==0)
     tempfilepointer = fopen (posfile_name,"rb");
   else
     tempfilepointer = posfile_pointer;

   if (tempfilepointer>0)
   {
      if (pos_file_binary==false)
      {
	 long temprecordsize = getrecordsizetext(tempfilepointer);
	 if (temprecordsize>0)
	 {
	    recordsize=temprecordsize;
	    posfile_pointer=tempfilepointer;
	 }
	 else
	 {
	    posfile_ready=false;
	    fclose (tempfilepointer);
	 }; //recordsize ==0
      }else //binary
      {
	 if (getlastposition(tempfilepointer)/(sizeof(float)*6)>0)
	 {
	    recordsize=sizeof(float)*6;
	    posfile_pointer=tempfilepointer;
	 }
	 else
	 {
	    posfile_ready=false;
	    fclose (tempfilepointer);
	 }; //no data sets in file

      };
   } else
   {
      posfile_ready=false;
   };//tempfilepointer<=0

   return  posfile_ready;
}

float KETSIM_ObjObject::force2color(float force)
{
  float color=(force-forcemin)/(forcemax-forcemin);
  if(color>1) color=1;
  if(color<0) color=0;
  return color;
}
