/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "ketsim_vz.h" // class's header file
#include <fstream>
#include <QImage>

KETSIM_VZ::KETSIM_VZ(char* body_name, char * pos_file): KetSim( body_name,  pos_file)
{
   std::ifstream minmaxfile("KETSIM_VZ.minmax");
   minmaxfile>>forcemin>>forcemax;
   minmaxfile.close();

   strcpy(body_file_name,body_name);
   strcpy(posfile_name , pos_file);
   int dummy_edge_flag;
   float* tempfloat;
   int result;
   vertex_data_struct* vertex_data;
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&parameter_1);
   parsenextdataline(datafile);

   while (1)
   {
      vertex_data = new vertex_data_struct;
      tempfloat = new float[3];
      result = GetCharacterLine(charstringline, 128, datafile);
      if (result == EOF) break; // Get out of while loop
      sscanf(charstringline, "%f %f %i \n", &tempfloat[X],
	     &tempfloat[Y], &dummy_edge_flag);
      tempfloat[Z] = 0.0;
      vertex_data->vertex_points = tempfloat;
      vertex_data->border_flag = dummy_edge_flag;
      VertexVector.push_back(vertex_data);
   };

   VertexVector=recalcContour(VertexVector);
}

KETSIM_VZ::~KETSIM_VZ()
{
}

void KETSIM_VZ::init()
{
   KetSim::init();
   glEnable(GL_NORMALIZE);
   vertex_data_struct* vertex_data;
   if (Displ_List) glDeleteLists(Displ_List, 1);
   Displ_List = glGenLists(1);
   glNewList(Displ_List, GL_COMPILE);
   glShadeModel(GL_SMOOTH);

   gluTessBeginPolygon(tobj, NULL);
   gluTessBeginContour(tobj);

   glNormal3f(0.0f, 0.0f, 1.0f);
   for(VertexVectorIterator = VertexVector.begin();
       VertexVectorIterator != VertexVector.end();
       VertexVectorIterator++)
   {
      vertex_data = *VertexVectorIterator;
      GLdouble * vertex_data_double = new GLdouble[3];
      vertex_data_double[X] = vertex_data->vertex_points[X];
      vertex_data_double[Y] = vertex_data->vertex_points[Y];
      vertex_data_double[Z] = 0.0;
      updateminmax(vertex_data_double) ;
      gluTessVertex(tobj,vertex_data_double, vertex_data_double );
   }

   gluTessEndContour(tobj);
   gluTessEndPolygon(tobj);

   glFrontFace( GL_CW);
   gluTessBeginPolygon(tobj, NULL);
   gluTessBeginContour(tobj);

   glNormal3f(0.0f, 0.0f, -1.0f);
   for(VertexVectorIterator = VertexVector.begin();
       VertexVectorIterator != VertexVector.end();
       VertexVectorIterator++)
   {
      vertex_data = *VertexVectorIterator;
      GLdouble * vertex_data_double = new GLdouble[3];
      vertex_data_double[X] = vertex_data->vertex_points[X];
      vertex_data_double[Y] = vertex_data->vertex_points[Y];
      vertex_data_double[Z] =-parameter_1;
      updateminmax(vertex_data_double) ;
      gluTessVertex(tobj,vertex_data_double, vertex_data_double );
   }
   gluTessEndContour(tobj);
   gluTessEndPolygon(tobj);


   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
   for(int i=0; i<10; ++i)
     glTexImage2D(GL_TEXTURE_2D, i, 4, amlogoWH[i], amlogoWH[i], 0, GL_RGBA, GL_UNSIGNED_BYTE, amlogo[i]);
   glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
   glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
   glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
   glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_LINEAR);
   glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
   
   float d=0.5*sqrt(2)*x_max * 0.7;
   glEnable(GL_TEXTURE_2D);
   glEnable(GL_POLYGON_OFFSET_FILL);
   glPolygonOffset(OFFSETFACM3,OFFSETUNITM3);
   glBegin(GL_QUADS);
     glNormal3f(0,0,1);
     glTexCoord2f(0.0, 0.0); glVertex3f(-d, -d, 0.0);
     glTexCoord2f(0.0, 1.0); glVertex3f(-d, +d, 0.0);
     glTexCoord2f(1.0, 1.0); glVertex3f(+d, +d, 0.0);
     glTexCoord2f(1.0, 0.0); glVertex3f(+d, -d, 0.0);
   glEnd();
   glBegin(GL_QUADS);
     glNormal3f(0,0,1);
     glTexCoord2f(1.0, 0.0); glVertex3f(-d, -d, -parameter_1);
     glTexCoord2f(1.0, 1.0); glVertex3f(-d, +d, -parameter_1);
     glTexCoord2f(0.0, 1.0); glVertex3f(+d, +d, -parameter_1);
     glTexCoord2f(0.0, 0.0); glVertex3f(+d, -d, -parameter_1);
   glEnd();
   glPolygonOffset(OFFSETFAC0,OFFSETUNIT0);
   glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
   glDisable(GL_TEXTURE_2D);


   int i,j,k,l;
   for(j=0;j<(int)VertexVector.size();j++) {
      i=j-1;
      if(i<0) i+=VertexVector.size();
      k=j+1;
      if(k>=(int)VertexVector.size()) k-=VertexVector.size();
      l=k+1;
      if(l>=(int)VertexVector.size()) l-=VertexVector.size();

      glBegin(GL_POLYGON);


      //Normal 1
      if(VertexVector[j]->border_flag==0)
	 glNormal3f((VertexVector[k]->vertex_points[Y]-VertexVector[i]->vertex_points[Y]),
		    (VertexVector[i]->vertex_points[X]-VertexVector[k]->vertex_points[X]),0);
      else
	 glNormal3f((VertexVector[k]->vertex_points[Y]-VertexVector[j]->vertex_points[Y]),
		    (VertexVector[j]->vertex_points[X]-VertexVector[k]->vertex_points[X]),0);

      //points 1 & 2
      glVertex3f(VertexVector[j]->vertex_points[X],VertexVector[j]->vertex_points[Y],-parameter_1);
      glVertex3f(VertexVector[j]->vertex_points[X],VertexVector[j]->vertex_points[Y], 0.0);

      //Normal 2
      if(VertexVector[k]->border_flag==0)
	 glNormal3f((VertexVector[l]->vertex_points[Y]-VertexVector[j]->vertex_points[Y]),
		    (VertexVector[j]->vertex_points[X]-VertexVector[l]->vertex_points[X]),0);
      else
	 glNormal3f((VertexVector[k]->vertex_points[Y]-VertexVector[j]->vertex_points[Y]),
		    (VertexVector[j]->vertex_points[X]-VertexVector[k]->vertex_points[X]),0);

      //points 3 & 4
      glVertex3f(VertexVector[k]->vertex_points[X],VertexVector[k]->vertex_points[Y],0.0 );
      glVertex3f(VertexVector[k]->vertex_points[X],VertexVector[k]->vertex_points[Y],-parameter_1);
      glEnd(); // GL_POLYGON

   };

glFrontFace( GL_CCW);

   glEndList();


   if (Contour_List) glDeleteLists(Contour_List, 1);
   Contour_List = glGenLists(1);
   glNewList(Contour_List, GL_COMPILE);
   glDisable(GL_LINE_SMOOTH);
   glEnable(GL_COLOR_MATERIAL);
   glLineWidth(1.0);
   glDisable(GL_LIGHTING);
   glColor3f(0.0, 0.0, 0.0);

   glPushMatrix();
   glTranslatef(0.0, 0.0,0.0 ) ;
   glBegin(GL_LINE_LOOP);
   for(VertexVectorIterator = VertexVector.begin();
       VertexVectorIterator != VertexVector.end();
       VertexVectorIterator++)
   {
      vertex_data = *VertexVectorIterator;
      glVertex3fv(vertex_data->vertex_points);
   }
   glEnd();
   glPopMatrix();

   glPushMatrix();
   glTranslatef(0.0, 0.0,-parameter_1) ;
   glBegin(GL_LINE_LOOP);
   glColor3f(0.0, 0.0, 0.0);
   for(VertexVectorIterator = VertexVector.begin();
       VertexVectorIterator != VertexVector.end();
       VertexVectorIterator++)
   {
      vertex_data = *VertexVectorIterator;
      glVertex3fv(vertex_data->vertex_points);
   }
   glEnd();
   glPopMatrix();

   for(j=0;j<(int)VertexVector.size();j++) {
      i=j-1;
      if(i<0) i+=VertexVector.size();
      k=j+1;
      if(k>=(int)VertexVector.size()) k-=VertexVector.size();
      l=k+1;
      if(l>=(int)VertexVector.size()) l-=VertexVector.size();

      if(VertexVector[j]->border_flag==1)
      {
	 glBegin(GL_LINES);
	 glVertex3f(VertexVector[j]->vertex_points[X],VertexVector[j]->vertex_points[Y],-parameter_1);
	 glVertex3f(VertexVector[j]->vertex_points[X],VertexVector[j]->vertex_points[Y],0.0);
	 glEnd();

      }
   };
   glEnable(GL_LIGHTING);
   glEndList();

}




// No description
void KETSIM_VZ::draw_contour()
{
   glCallList(Contour_List);
}





void KETSIM_VZ::return_info_string(QString &info)
{
   KetSim::return_info_string(info);
   info=info+tr("\nTorque: %1Nm").arg(force);
}


