/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "ketsim_zk_ag_fl2.h" // class's header file
#include <fstream>

KETSIM_ZK_AG_FL2::KETSIM_ZK_AG_FL2(char* body_name, char * pos_file): KetSim( body_name,  pos_file)
{
   std::ifstream minmaxfile("KETSIM_Gl_ZKFL.minmax");
   minmaxfile>>forcemin>>forcemax;
   minmaxfile.close();

   strcpy(body_file_name,body_name);
   strcpy(posfile_name , pos_file);
   float* tempfloat;
   int result;
   vertex_data_struct* vertex_data;
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&parameter_1);
   parsenextdataline(datafile);

   result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&parameter_2);
   parsenextdataline(datafile);

   result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&parameter_3);
   parsenextdataline(datafile);

   result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&parameter_4);
   parsenextdataline(datafile);

   result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&parameter_5);
   parsenextdataline(datafile);
   
      result = GetCharacterLine(charstringline, 128, datafile);
   sscanf(charstringline, "%f\n" ,&parameter_6);
   parsenextdataline(datafile);


    vertex_data = new vertex_data_struct;
    tempfloat = new float[3];
    tempfloat[X]=-parameter_3;
    tempfloat[Y]=  parameter_2 /2;
    tempfloat[Z]= -parameter_4 ;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 1;   
    VertexVector.push_back(vertex_data);  
      
    vertex_data = new vertex_data_struct;
    tempfloat = new float[3];
    tempfloat[X]= 0.0;
    tempfloat[Y]=parameter_2 /2;
    tempfloat[Z]= -parameter_4 ;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 0;   
    VertexVector.push_back(vertex_data);  


   
    double dangle=M_PI/180*360.0/NCIRCLE(parameter_2/2);
    for(float angle = 0.0f*M_PI+dangle; angle < (1.0f*M_PI); angle += dangle)
   {
     vertex_data = new vertex_data_struct;
     tempfloat = new float[3];
     tempfloat[X]= parameter_2 /2*(float)sin(angle);
     tempfloat[Y]= parameter_2 /2*(float)cos(angle);
     tempfloat[Z]= -parameter_4 ;
     vertex_data->vertex_points = tempfloat;
     vertex_data->border_flag = 0;   
     VertexVector.push_back(vertex_data); 

   };
   
   
   
    vertex_data = new vertex_data_struct;
    tempfloat = new float[3];
    tempfloat[X]= 0.0;
    tempfloat[Y]= -parameter_2 /2;
    tempfloat[Z]= -parameter_4 ;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 0;   
    VertexVector.push_back(vertex_data); 
   
    vertex_data = new vertex_data_struct;
    tempfloat = new float[3];
    tempfloat[X]= -parameter_3;
    tempfloat[Y]= -parameter_2 /2;
    tempfloat[Z]= -parameter_4 ;
    vertex_data->vertex_points = tempfloat;
    vertex_data->border_flag = 1;   
    VertexVector.push_back(vertex_data);  

   VertexVector=recalcContour(VertexVector);
}

KETSIM_ZK_AG_FL2::~KETSIM_ZK_AG_FL2()
{
}

void KETSIM_ZK_AG_FL2::init()
{
   KetSim::init();
   glEnable(GL_NORMALIZE);
   vertex_data_struct* vertex_data;
   if (Displ_List) glDeleteLists(Displ_List, 1);
   Displ_List = glGenLists(1);
   glNewList(Displ_List, GL_COMPILE);
   glShadeModel(GL_SMOOTH);

   gluTessBeginPolygon(tobj, NULL);

   glFrontFace( GL_CW);
   gluTessBeginContour(tobj);
   glNormal3f(0.0f, 0.0f, 1.0f);

   for(VertexVectorIterator = VertexVector.begin();
       VertexVectorIterator != VertexVector.end();
       VertexVectorIterator++)
   {
      vertex_data = *VertexVectorIterator;
      GLdouble * vertex_data_double = new GLdouble[3];
      vertex_data_double[X] = vertex_data->vertex_points[X];
      vertex_data_double[Y] = vertex_data->vertex_points[Y];
      vertex_data_double[Z] = -parameter_4;
      updateminmax(vertex_data_double) ;
      gluTessVertex(tobj,vertex_data_double, vertex_data_double );
   }

   gluTessEndContour(tobj);
   gluTessEndPolygon(tobj);
glFrontFace( GL_CCW);

   gluTessBeginPolygon(tobj, NULL);
   gluTessBeginContour(tobj);

   glNormal3f(0.0f, 0.0f, -1.0f);
   for(VertexVectorIterator = VertexVector.begin();
       VertexVectorIterator != VertexVector.end();
       VertexVectorIterator++)
   {
      vertex_data = *VertexVectorIterator;
      GLdouble * vertex_data_double = new GLdouble[3];
      vertex_data_double[X] = vertex_data->vertex_points[X];
      vertex_data_double[Y] = vertex_data->vertex_points[Y];
      vertex_data_double[Z] =-parameter_4 - parameter_5 ;
      updateminmax(vertex_data_double) ;
      gluTessVertex(tobj,vertex_data_double, vertex_data_double );
   }
   gluTessEndContour(tobj);
   gluTessEndPolygon(tobj);

 glFrontFace( GL_CCW);

   int i,j,k,l;
   for(j=0;j<(int)VertexVector.size();j++) {
      i=j-1;
      if(i<0) i+=VertexVector.size();
      k=j+1;
      if(k>=(int)VertexVector.size()) k-=VertexVector.size();
      l=k+1;
      if(l>=(int)VertexVector.size()) l-=VertexVector.size();

      glBegin(GL_POLYGON);


      //Normal 1
      if(VertexVector[j]->border_flag==0)
	 glNormal3f(-(VertexVector[k]->vertex_points[Y]-VertexVector[i]->vertex_points[Y]),
		    -(VertexVector[i]->vertex_points[X]-VertexVector[k]->vertex_points[X]),0);
      else
	 glNormal3f(-(VertexVector[k]->vertex_points[Y]-VertexVector[j]->vertex_points[Y]),
		    -(VertexVector[j]->vertex_points[X]-VertexVector[k]->vertex_points[X]),0);

      //points 1 & 2
      glVertex3f(VertexVector[j]->vertex_points[X],VertexVector[j]->vertex_points[Y],-parameter_4 - parameter_5);
      glVertex3f(VertexVector[j]->vertex_points[X],VertexVector[j]->vertex_points[Y],-parameter_4);

      //Normal 2
      if(VertexVector[k]->border_flag==0)
	 glNormal3f(-(VertexVector[l]->vertex_points[Y]-VertexVector[j]->vertex_points[Y]),
		    -(VertexVector[j]->vertex_points[X]-VertexVector[l]->vertex_points[X]),0);
      else
	 glNormal3f(-(VertexVector[k]->vertex_points[Y]-VertexVector[j]->vertex_points[Y]),
		    -(VertexVector[j]->vertex_points[X]-VertexVector[k]->vertex_points[X]),0);

      //points 3 & 4
      glVertex3f(VertexVector[k]->vertex_points[X],VertexVector[k]->vertex_points[Y],-parameter_4);
      glVertex3f(VertexVector[k]->vertex_points[X],VertexVector[k]->vertex_points[Y],-parameter_4 - parameter_5);
      glEnd(); // GL_POLYGON

   };

   GLUquadricObj *quadObj;
   quadObj = gluNewQuadric();
   gluQuadricDrawStyle(quadObj, GLU_FILL);

   float minmax[3];
   minmax[0]= parameter_1/2;
   minmax[1]= parameter_2/2;
   minmax[2]= 0.0;
   updateminmax(minmax) ;
   
   minmax[0]= parameter_1/2;
   minmax[1]= parameter_2/2;
   minmax[2]= -parameter_4 -parameter_5 -parameter_6;
   updateminmax(minmax) ;
   
   Circle(parameter_1, 0, 360, true);
   glNormal3f(0.0f, 0.0f, 1.0f);
   
   glPushMatrix();
   glTranslatef(0.0, 0.0, -parameter_4 -parameter_5 -parameter_6) ;
   Circle(parameter_1, 0, 360, false);
   
   gluCylinder(quadObj, parameter_1, parameter_1, parameter_4, NCIRCLE(parameter_1), 1);  /* draw a cone */
   glPopMatrix();


   glPushMatrix();
   glTranslatef(0.0, 0.0, -parameter_4) ;
   gluCylinder(quadObj, parameter_1, parameter_1, parameter_4, NCIRCLE(parameter_1), 1);  /* draw a cone */
   glPopMatrix();


   glEndList();


   if (Contour_List) glDeleteLists(Contour_List, 1);
   Contour_List = glGenLists(1);
   glNewList(Contour_List, GL_COMPILE);
   glDisable(GL_LINE_SMOOTH);
   glEnable(GL_COLOR_MATERIAL);
   glLineWidth(1.0);
   glDisable(GL_LIGHTING);
   glColor3f(0.0, 0.0, 0.0);

   Circle_Line(parameter_1);
   
   glPushMatrix();
   glTranslatef(0.0, 0.0, -parameter_4 -parameter_5 -parameter_6) ;
   Circle_Line(parameter_1);
   glPopMatrix();
   
   glPushMatrix();
   glTranslatef(0.0, 0.0, -parameter_4) ;
   Circle_Line(parameter_1);
   glPopMatrix();

   glPushMatrix();
   glTranslatef(0.0, 0.0, -parameter_4 -parameter_5) ;
   Circle_Line(parameter_1);
   glPopMatrix();
   
   glPushMatrix();
   glTranslatef(0.0, 0.0, 0.0 ) ;
   glBegin(GL_LINE_STRIP);
   for(VertexVectorIterator = VertexVector.begin();
       VertexVectorIterator != VertexVector.end();
       VertexVectorIterator++)
   {
      vertex_data = *VertexVectorIterator;
      glVertex3fv(vertex_data->vertex_points);
   }
   glEnd();
   glPopMatrix();

   glPushMatrix();
   glTranslatef(0.0, 0.0, - parameter_5) ;
   glBegin(GL_LINE_STRIP);
   glColor3f(0.0, 0.0, 0.0);
   for(VertexVectorIterator = VertexVector.begin();
       VertexVectorIterator != VertexVector.end();
       VertexVectorIterator++)
   {
      vertex_data = *VertexVectorIterator;
      glVertex3fv(vertex_data->vertex_points);
   }
   glEnd();
   glPopMatrix();

   for(j=0;j<(int)VertexVector.size();j++) {
      i=j-1;
      if(i<0) i+=VertexVector.size();
      k=j+1;
      if(k>=(int)VertexVector.size()) k-=VertexVector.size();
      l=k+1;
      if(l>=(int)VertexVector.size()) l-=VertexVector.size();

      if(VertexVector[j]->border_flag==1)
      {
// 	 glBegin(GL_LINES);
// 	 glVertex3f(VertexVector[j]->vertex_points[X],VertexVector[j]->vertex_points[Y],-parameter_4);
// 	 glVertex3f(VertexVector[j]->vertex_points[X],VertexVector[j]->vertex_points[Y],-parameter_4 - parameter_5);
// 	 glEnd();

      }
   };
   glEnable(GL_LIGHTING);
   glEndList();

}

void KETSIM_ZK_AG_FL2::draw_contour()
{
   glCallList(Contour_List);
}




void KETSIM_ZK_AG_FL2::return_info_string(QString &info)
{
   KetSim::return_info_string(info);
   info=info+tr("\nForce: %1N").arg(force);
}
