/*
   AMVis - 3D Multibody Visualisation Program.
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technische Universitaet Muenchen

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   */

#include <GL/gl.h>
#include "kos.h" // class's header file

Kos::Kos(char* body_name, char * pos_file): CRigidBody( body_name, pos_file), Contour_List(0)
{
	strcpy(body_file_name,body_name);
	strcpy(posfile_name , pos_file);
	int result;
	char* charstringline = new char [charlength];
	parsenextdataline(datafile);
	result = GetCharacterLine(charstringline, charlength, datafile);
	sscanf(charstringline, "%f\n" ,&l);
	parsenextdataline(datafile);
	result = GetCharacterLine(charstringline, charlength, datafile);
	sscanf(charstringline, "%f\n" ,&anteilPos);
	if (anteilPos>1.)
		anteilPos=1.;
	if (anteilPos<0.)
		anteilPos=0.;
	parsenextdataline(datafile);
}

Kos::Kos(FILE *bodyfile): CRigidBody(bodyfile), Contour_List(0)
{
	int result;
	char* charstringline = new char [charlength];
	parsenextdataline(datafile);
	result = GetCharacterLine(charstringline, charlength, datafile);
	sscanf(charstringline, "%f\n" ,&l);
	parsenextdataline(datafile);
	result = GetCharacterLine(charstringline, charlength, datafile);
	sscanf(charstringline, "%f\n" ,&anteilPos);
	parsenextdataline(datafile);
}

// class destructor
Kos::~Kos()
{
}

void Kos::init()
{
	CRigidBody::init();
	
	float minmax[3];
	float minWert=.5*l*(anteilPos-1.);
	float maxWert=.5*l*(anteilPos+1.);
	
	minmax[0] = minWert;
	minmax[1] = minWert;
	minmax[2] = minWert;
	updateminmax(minmax) ;
	
	minmax[0] = maxWert;
	minmax[1] = maxWert;
	minmax[2] = maxWert;
	updateminmax(minmax) ;

	if (Displ_List)
		glDeleteLists(Displ_List, 1);
	Displ_List = glGenLists(1);
	glNewList(Displ_List, GL_COMPILE);

	glDisable(GL_LIGHTING);
	glLineWidth(2.0);
	GLfloat currColor[4];
	glGetFloatv(GL_CURRENT_COLOR, currColor);
	
	glColor3f(1,0,0);
	glBegin(GL_LINES);
	glVertex3f(minWert,0,0);
	glVertex3f(maxWert,0,0);
	glEnd();
	glColor3f(0,1,0);
	glBegin(GL_LINES);
	glVertex3f(0,minWert,0);
	glVertex3f(0,maxWert,0);
	glEnd();
	glColor3f(0,0,1);
	glBegin(GL_LINES);
	glVertex3f(0,0,minWert);
	glVertex3f(0,0,maxWert);
	glEnd();
	
	glColor3f(currColor[0], currColor[1], currColor[2]);
	glEnable(GL_LIGHTING);
	glLineWidth(1.0);

	glEndList();
}
