#include "wave.h"
#include <math.h>
#include <string.h>


void appendpath(char *fname, char *takepathfromfilename, char *fnamewithpath) {
#ifdef UNIX
 if(fname[0]=='/')
   strcpy(fnamewithpath,fname);
 else {
   strcpy(fnamewithpath,takepathfromfilename);
   char *s=strrchr(fnamewithpath,'/');
   if(s==NULL)
     strcpy(fnamewithpath,fname);
   else {
     s[1]=0;
     strcat(fnamewithpath,fname);
   }
 }
#elif defined WINDOWS
 if(fname[1]==':')
   strcpy(fnamewithpath,fname);
 else {
   strcpy(fnamewithpath,takepathfromfilename);
   char *s=strrchr(fnamewithpath,'\\');
   if(s==NULL)
     strcpy(fnamewithpath,fname);
   else {
     s[1]=0;
     strcat(fnamewithpath,fname);
   }
 }
#endif 
}

void fixospath(char *fname) {
  char *s;
  for(s=fname; *s; s++)
#ifdef UNIX
    if(*s=='\\') *s='/';
#elif defined WINDOWS
    if(*s=='/') *s='\\';
#endif
}


static struct { int id,value; } wfFeature[] = 
	{
	 { WF_SHOW_DEFINED_TEXTURES, 0 },
	 { WF_USE_TEXTURES, 1 },
	 { WF_USE_MATERIALS, 1 },
	 { WF_INCLUDE_ALL_PARTS, 0 },
	 { WF_DRAW_WIREFRAME, 0 },
	 { -1, 0 }
	};

void wfEnable(int id)
{
 int i;
 for (i=0; wfFeature[i].id > -1; i++)
	if (wfFeature[i].id == id)
		{
		wfFeature[i].value = 1;
		return;
		}
 fprintf(stderr,"wfEnable error: invalid id %d\n",id);
}

int wfIsEnabled(int id)
{
 int i;
 for (i=0; wfFeature[i].id > -1; i++)
	if (wfFeature[i].id == id)
		return wfFeature[i].value;
 fprintf(stderr,"wfIsEnabled error: invalid id %d\n",id);
 return 0;
}

void wfDisable(int id)
{
 int i;
 for (i=0; wfFeature[i].id > -1; i++)
	if (wfFeature[i].id == id)
		{
		wfFeature[i].value = 0;
		return;
		}
 fprintf(stderr,"wfDisable error: invalid id %d\n",id);
}

static int (*wfNewIDFunc)(void) = NULL;

void wfSetNewIDFunction(int (*idfn)(void))
{
 wfNewIDFunc = idfn;
}

/* wfNewID - returns a new ('unique') ID number. For materials, texmaps, etc. */
int wfNewID(void)
{
 if (wfNewIDFunc) return (*wfNewIDFunc)();
 else
	{
#ifdef IRISGL
	next_number++;
	return next_number;
#else
	return glGenLists(1);
#endif
	}
}

/* wfGetBoundingSphere - computes the center and radius of a bounding
	sphere for an object. */
void wfGetBoundingSphere(wfObject *obj,wfVertex center,float *radius)
{
 float xsum,ysum,zsum,dx,dy,dz,d,maxd;
 int i;
 if ((!obj) || (!obj->nverts)) return;
 xsum = ysum = zsum = 0.0;
 for (i=0; i<obj->nverts; i++)
	{
	xsum += obj->vert[i][0];
	ysum += obj->vert[i][1];
	zsum += obj->vert[i][2];
	}
 center[0] = xsum/obj->nverts;
 center[1] = ysum/obj->nverts;
 center[2] = zsum/obj->nverts;
 maxd = 0;
 for (i=0; i<obj->nverts; i++)
	{
	dx = obj->vert[i][0] - center[0];
	dy = obj->vert[i][1] - center[1];
	dz = obj->vert[i][2] - center[2];
	d = dx*dx + dy*dy + dz*dz;
	if (d>maxd) maxd = d;
	}
 *radius = sqrt(maxd);
}

/* wfGetBoundingBox - computes an axis-aligned bounding box for an object.
	It is returned as two corner vertices (minx,miny,minz) &
	(maxx,maxy,maxz). */
void wfGetBoundingBox(wfObject *obj,wfVertex corner0,
			wfVertex corner1)
{
 float minx,miny,minz,maxx,maxy,maxz;
 int i;
 if ((!obj) || (!obj->nverts)) return;
 minx = maxx = obj->vert[0][0];
 miny = maxy = obj->vert[0][1];
 minz = maxz = obj->vert[0][2];
 for (i=1; i<obj->nverts; i++)
	{
	if (obj->vert[i][0] < minx) minx = obj->vert[i][0];
	else if (obj->vert[i][0] > maxx) maxx = obj->vert[i][0];
	if (obj->vert[i][1] < miny) miny = obj->vert[i][1];
	else if (obj->vert[i][1] > maxy) maxy = obj->vert[i][1];
	if (obj->vert[i][2] < minz) minz = obj->vert[i][2];
	else if (obj->vert[i][2] > maxz) maxz = obj->vert[i][2];
	}
 corner0[0] = minx;
 corner0[1] = miny;
 corner0[2] = minz;
 corner1[0] = maxx;
 corner1[1] = maxy;
 corner1[2] = maxz;
}

wfObject * wfCopyObjectGeometry(wfObject *obj)
{
 wfObject *newobj = (wfObject *) wfAlloc(sizeof(wfObject));
 newobj->nverts = obj->nverts;
 newobj->vert = (wfVertex *) wfAlloc(obj->nverts * sizeof(wfVertex));
 memcpy(newobj->vert,obj->vert,obj->nverts * sizeof(wfVertex));
 newobj->nnorms = obj->nnorms;
 newobj->norm = (wfNormal *) wfAlloc(obj->nnorms * sizeof(wfNormal));
 memcpy(newobj->norm,obj->norm,obj->nnorms * sizeof(wfNormal));
 newobj->ntexcoords = obj->ntexcoords;
 newobj->texc = obj->texc;
 newobj->parts = obj->parts;
 newobj->materials = obj->materials;
 newobj->texmaps = obj->texmaps;
 newobj->gl_initted = obj->gl_initted;
 newobj->app_data = obj->app_data;
 return newobj;
}

// BEGIN added by Markus Friedrich
void wfCombineVertices(wfObject *obj, float eps) {
  int i, j;
  wfPart *p;
  int max=10000, size=0;
  int *changeFrom, *changeTo;
  changeFrom=(int*)malloc(sizeof(int)*max);
  changeTo=(int*)malloc(sizeof(int)*max);
  for(i=0; i<obj->nverts-1; ++i) {
    for(j=i+1; j<obj->nverts; ++j) {
      if( fabs(obj->vert[i][0]-obj->vert[j][0])<=eps &&
          fabs(obj->vert[i][1]-obj->vert[j][1])<=eps &&
          fabs(obj->vert[i][2]-obj->vert[j][2])<=eps ) {
        if(size>=max) {
          max*=2;
          changeFrom=(int*)realloc(changeFrom, sizeof(int)*max);
          changeTo=(int*)realloc(changeTo, sizeof(int)*max);
        }
        changeFrom[size]=j+1;
        changeTo[size]=i+1;
        size++;
      }
    }
  }
  for(p=obj->parts; p; p=p->next) {
    if(p->parttype!=WF_FACE) continue;
    wfFace *f=&(p->part.face);
    for(i=0; i<size; ++i) {
      int j;
      for(j=0; j<f->nverts; ++j)
        if(f->vert[j]==changeFrom[i]) f->vert[j]=changeTo[i];
    }
  }
  free(changeFrom);
  free(changeTo);
}

void wfCombineNormals(wfObject *obj, float eps) {
  int i, j;
  wfPart *p;
  int max=10000, size=0;
  int *changeFrom, *changeTo;
  changeFrom=(int*)malloc(sizeof(int)*max);
  changeTo=(int*)malloc(sizeof(int)*max);
  for(i=0; i<obj->nnorms-1; ++i) {
    for(j=i+1; j<obj->nnorms; ++j) {
      if( fabs(obj->norm[i][0]-obj->norm[j][0])<=eps &&
          fabs(obj->norm[i][1]-obj->norm[j][1])<=eps &&
          fabs(obj->norm[i][2]-obj->norm[j][2])<=eps ) {
        if(size>=max) {
          max*=2;
          changeFrom=(int*)realloc(changeFrom, sizeof(int)*max);
          changeTo=(int*)realloc(changeTo, sizeof(int)*max);
        }
        changeFrom[size]=j+1;
        changeTo[size]=i+1;
        size++;
      }
    }
  }
  for(p=obj->parts; p; p=p->next) {
    if(p->parttype!=WF_FACE) continue;
    wfFace *f=&(p->part.face);
    for(i=0; i<size; ++i) {
      int j;
      for(j=0; j<f->nverts; ++j)
        if(f->norm[j]==changeFrom[i]) f->norm[j]=changeTo[i];
    }
  }
  free(changeFrom);
  free(changeTo);
}

/*GLuint wfGenOutline(wfObject *obj) {
  GLuint list;
  list=glGenLists(1);
  glNewList(list, GL_COMPILE);
    wfPart *pa, *pb;
    int veq;
    int vert[1000]; // max size?????
    for(pa=obj->parts; pa; pa=pa->next) {
      if(pa->parttype!=WF_FACE) continue;
      wfFace *fa=&(pa->part.face);
      for(pb=pa->next; pb; pb=pb->next) {
        if(pb->parttype!=WF_FACE) continue;
        wfFace *fb=&(pb->part.face);
        veq=0;
        int i, j;
        for(i=0; i<fa->nverts; ++i) {
          for(j=0; j<fb->nverts; ++j)
            if( fa->vert[i]==fb->vert[j] && fa->norm[i]!=fb->norm[j] ) {
              vert[veq]=fa->vert[i];
              veq++;
              if(veq>=2) break;
            }
          if(veq>=2) break;
        }
        if(veq>=2) {
          glBegin(GL_LINES);
            glVertex3fv(obj->vert[vert[0]-1]);
            glVertex3fv(obj->vert[vert[1]-1]);
          glEnd();
        }
      }
    }
  glEndList();
  return list;
}*/
wfObject* wfGenOutline(wfObject *obj) {
  wfObject *outobj=(wfObject*)malloc(sizeof(wfObject));
  outobj->nverts=0;
  outobj->vert=(wfVertex*)malloc(sizeof(wfVertex)*10000000);
  outobj->nnorms=0;
  outobj->norm=0;
  outobj->ntexcoords=0;
  outobj->texc=0;
  outobj->parts=0;
  outobj->lastPart=0;
  outobj->texmaps=0;
  outobj->gl_initted=1;
  outobj->app_data=0;
  outobj->allParts=0;
  outobj->objfilename=0;

  wfPart *pa, *pb;
  int veq;
  int vert[1000]; // max size?????
  for(pa=obj->parts; pa; pa=pa->next) {
    if(pa->parttype!=WF_FACE) continue;
    wfFace *fa=&(pa->part.face);
    for(pb=pa->next; pb; pb=pb->next) {
      if(pb->parttype!=WF_FACE) continue;
      wfFace *fb=&(pb->part.face);
      veq=0;
      int i, j;
      for(i=0; i<fa->nverts; ++i) {
        for(j=0; j<fb->nverts; ++j)
          if( fa->vert[i]==fb->vert[j] && fa->norm[i]!=fb->norm[j] ) {
            vert[veq]=fa->vert[i];
            veq++;
            if(veq>=2) break;
          }
        if(veq>=2) break;
      }
      if(veq>=2) {

        outobj->vert[outobj->nverts][0]=obj->vert[vert[0]-1][0];
        outobj->vert[outobj->nverts][1]=obj->vert[vert[0]-1][1];
        outobj->vert[outobj->nverts][2]=obj->vert[vert[0]-1][2];
        outobj->nverts++;
        outobj->vert[outobj->nverts][0]=obj->vert[vert[1]-1][0];
        outobj->vert[outobj->nverts][1]=obj->vert[vert[1]-1][1];
        outobj->vert[outobj->nverts][2]=obj->vert[vert[1]-1][2];
        outobj->nverts++;
        wfPart *outp=(wfPart*)malloc(sizeof(wfPart));
        outp->parttype=WF_LINE;
        outp->part.line.nverts=2;
        outp->part.line.vert=(int*)malloc(sizeof(int)*2);
        outp->part.line.vert[0]=outobj->nverts-1;
        outp->part.line.vert[1]=outobj->nverts-0;
        outp->next=0;
        if(outobj->parts==0)
          outobj->parts=outp;
        if(outobj->lastPart==0)
          outobj->lastPart=outp;
        else {
          outobj->lastPart->next=outp;
          outobj->lastPart=outp;
        }

//        glBegin(GL_LINES);
//          glVertex3fv(obj->vert[vert[0]-1]);
//          glVertex3fv(obj->vert[vert[1]-1]);
//        glEnd();
      }
    }
  }

  outobj->vert=(wfVertex*)realloc(outobj->vert,sizeof(wfVertex)*outobj->nverts);
  return outobj;
}
// END added by Markus Friedrich
