#include <stdio.h>
#include <math.h>
#include <string.h>
#include "wave.h"

#define bzero(a,b) memset(a,0,b)

static int countFaces(wfObject *obj);
static void computeFaceNormal(wfFace *face,wfObject *obj,wfNormal norm,int clockwise);
static void assignNormalIndices(wfFace *face,int faceNum,int smooth);
static void addNormalToVertNorms(wfFace *face,wfObject *obj,wfNormal norm);
static void normalizeNormal(wfNormal norm);


void wfComputeNormals(wfObject *obj,int smooth,int clockwise)
{
 int numFaces = countFaces(obj),i;
 wfNormal *faceNorm;
 wfPart *part;
 if (obj->norm)
	wfFree(obj->norm);
 if (smooth)
	obj->nnorms = obj->nverts;
 else
	obj->nnorms = numFaces;
 obj->norm = (wfNormal *) wfAlloc(obj->nnorms * sizeof(wfNormal));
 faceNorm = (wfNormal *) wfAlloc(numFaces * sizeof(wfNormal));
 if (smooth)
	bzero(obj->norm,obj->nnorms * sizeof(wfNormal));
 for (part = obj->parts, i=0; part; part = part->next)
	if (part->parttype == WF_FACE)
		{
		computeFaceNormal(&part->part.face,obj,faceNorm[i],clockwise);
		assignNormalIndices(&part->part.face,i,smooth);
		if (smooth)
			addNormalToVertNorms(&part->part.face,obj,faceNorm[i]);
		i++;
		}
 if (smooth)
	for (i=0; i<obj->nnorms; i++)
		normalizeNormal(obj->norm[i]);
 else
	memcpy(obj->norm,faceNorm,numFaces * sizeof(wfNormal));
 free(faceNorm);
}

static int countFaces(wfObject *obj)
{
 wfPart *part;
 int num=0;
 for (part = obj->parts; part; part = part->next)
	if (part->parttype == WF_FACE)
		num++;
 return num;
}

static void computeFaceNormal(wfFace *face,wfObject *obj,wfNormal norm,int clockwise)
{
 float *v0,*v1,*v2;
 float dx1,dy1,dz1,dx2,dy2,dz2,nx,ny,nz,len;
 norm[0] = norm[1] = 0; norm[2] = 1;	/* Default value in case of error */
 if (face->nverts < 3)
	return;
 v0 = obj->vert[face->vert[0] - 1];
 v1 = obj->vert[face->vert[1] - 1];
 v2 = obj->vert[face->vert[2] - 1];
 if (clockwise)
	{
	dx1 = v0[0] - v1[0];
	dy1 = v0[1] - v1[1];
	dz1 = v0[2] - v1[2];
	dx2 = v2[0] - v1[0];
	dy2 = v2[1] - v1[1];
	dz2 = v2[2] - v1[2];
	}
 else
	{
	dx2 = v0[0] - v1[0];
	dy2 = v0[1] - v1[1];
	dz2 = v0[2] - v1[2];
	dx1 = v2[0] - v1[0];
	dy1 = v2[1] - v1[1];
	dz1 = v2[2] - v1[2];
	}
 nx = dy1*dz2 - dy2*dz1;
 ny = dz1*dx2 - dz2*dx1;
 nz = dx1*dy2 - dx2*dy1;
 len = sqrt(nx*nx + ny*ny + nz*nz);
 if (len < 1e-20)
	return;
 norm[0] = nx / len;
 norm[1] = ny / len;
 norm[2] = nz / len;
}

static void assignNormalIndices(wfFace *face,int faceNum,int smooth)
{
 int i;
 if (!face->norm)
	face->norm = (int *) wfAlloc(face->nverts * sizeof(int));
 if (smooth)
	{
	for (i=0; i<face->nverts; i++)
		face->norm[i] = face->vert[i];
	}
 else
	{
	for (i=0; i<face->nverts; i++)
		face->norm[i] = faceNum + 1;
	}
}

static void addNormalToVertNorms(wfFace *face,wfObject *obj,wfNormal norm)
{
 int i,v;
 for (i=0; i<face->nverts; i++)
	{
	v = face->vert[i] - 1;
	obj->norm[v][0] += norm[0];
	obj->norm[v][1] += norm[1];
	obj->norm[v][2] += norm[2];
	}
}

static void normalizeNormal(wfNormal norm)
{
 float len;
 len = sqrt(norm[0]*norm[0] + norm[1]*norm[1] + norm[2]*norm[2]);
 if (len < 1e-20)
	{
	0[norm] = 1[norm] = 0;
	2[norm] = 1;
	}
 else
	{
	norm[0] /= len;
	norm[1] /= len;
	norm[2] /= len;
	}
}

void wfComputeNormals2(wfObject *obj, float epsangle) {
  wfPart *p;
  // count face edges
  int num=0;
  for(p=obj->parts; p; p=p->next) {
    if(p->parttype!=WF_FACE) continue;
    wfFace *f=&(p->part.face);
    num+=f->nverts;
  }
  obj->nnorms=num;
  // realloc normals
  wfFree(obj->norm);
  obj->norm=wfAlloc(sizeof(wfNormal)*num);
  // calculate face normals
  int i=0;
  for(p=obj->parts; p; p=p->next) {
    if(p->parttype!=WF_FACE) continue;
    wfFace *f=&(p->part.face);
    wfNormal n;
    computeFaceNormal(f,obj,n,0);
    int j;
    for(j=0; j<f->nverts; ++j) {
      f->norm[j]=i+1;
      obj->norm[i][0]=n[0];
      obj->norm[i][1]=n[1];
      obj->norm[i][2]=n[2];
      ++i;
    }
  }
  // compute
  wfPart *pa, *pb;
  int veq;
  int na[2], nb[2];
  for(pa=obj->parts; pa; pa=pa->next) {
    if(pa->parttype!=WF_FACE) continue;
    wfFace *fa=&(pa->part.face);
    for(pb=pa->next; pb; pb=pb->next) {
      if(pb->parttype!=WF_FACE) continue;
      wfFace *fb=&(pb->part.face);
      int i, j;
      veq=0;
      for(i=0; i<fa->nverts; ++i) {
        for(j=0; j<fb->nverts; ++j)
          if( fa->vert[i]==fb->vert[j] ) {
	    na[veq]=fa->norm[i];
	    nb[veq]=fb->norm[j];
            veq++;
            if(veq>=2) {
	      int k;
	      for(k=0; k<2; ++k) {
	        float angle;
	        angle=obj->norm[na[k]-1][0]*obj->norm[nb[k]-1][0]+
	              obj->norm[na[k]-1][1]*obj->norm[nb[k]-1][1]+
	              obj->norm[na[k]-1][2]*obj->norm[nb[k]-1][2];
	        angle/=sqrt(obj->norm[na[k]-1][0]*obj->norm[na[k]-1][0]+
	               obj->norm[na[k]-1][1]*obj->norm[na[k]-1][1]+
	               obj->norm[na[k]-1][2]*obj->norm[na[k]-1][2]);
	        angle/=sqrt(obj->norm[nb[k]-1][0]*obj->norm[nb[k]-1][0]+
	               obj->norm[nb[k]-1][1]*obj->norm[nb[k]-1][1]+
	               obj->norm[nb[k]-1][2]*obj->norm[nb[k]-1][2]);
	        angle=acos(angle);
    	        if(angle<=epsangle) {
    	          obj->norm[na[k]-1][0]+=obj->norm[nb[k]-1][0];
    	          obj->norm[na[k]-1][1]+=obj->norm[nb[k]-1][1];
    	          obj->norm[na[k]-1][2]+=obj->norm[nb[k]-1][2];
		  wfPart *p;
                  for(p=obj->parts; p; p=p->next) {
                    if(p->parttype!=WF_FACE) continue;
                    wfFace *f=&(p->part.face);
		    int l;
		    for(l=0;l<f->nverts;++l)
		      if(f->norm[l]==nb[k])
			f->norm[l]=na[k];
		  }
	        }
	      }
	      veq=0;
	    }
          }
      }
    }
  }
  // normalize
  for(i=0; i<obj->nnorms; ++i)
    normalizeNormal(obj->norm[i]);
}
