/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <QApplication>

#include "mainwindow.h"
#include <QPlastiqueStyle>

#ifdef STATIC
  Q_IMPORT_PLUGIN(qsvg)
#endif

int main(int argc, char *argv[])
{
    bool help=false;
	bool minDocks=false;
	bool play=false;
    QString wst (":/default.wst");
    QString view(":/default.vpt");
	double speed=1.0;
	for(int i=1; i<argc; i++) {
	  if(strcmp(argv[i],"-?")==0 ||
		  strcmp(argv[i],"-h")==0 ||
		  strcmp(argv[i],"--help")==0 ||
		  strcmp(argv[i],"/?")==0 ||
		  strcmp(argv[i],"/h")==0 ||
		  strcmp(argv[i],"/help")==0)
		help=true;
	  if(strcmp(argv[i],"--mindocks")==0)
		minDocks=true;
	  if(strncmp(argv[i],"--wst=",6)==0) {
		wst=argv[i]+6;
	  }
	  if(strncmp(argv[i],"--view=",6)==0) {
		view=argv[i]+7;
	  }
	  if(strcmp(argv[i],"--license")==0) {
		QFile file(":/COPYING");
		file.open(QFile::ReadOnly);
		char buf[1024];
		while(file.readLine(buf, sizeof(buf))!=-1)
		  printf("%s", buf);
		file.close();
		return 0;
	  }
	  if(strcmp(argv[i],"--play")==0) {
		play=true;
		cout << "auto-Play" << endl;
	  }
	  if(strncmp(argv[i],"--speed=",8)==0) {
		sscanf(argv[i]+8,"%lf",&speed);
		cout << "speed = " << speed << endl;
	  }
	}

    if(help) {
      printf("AMVis - 3D Multibody Visualisation Program - Version %d.%d.%d\n",V1,V2,V3);
      printf("\n");
      printf("Copyright (c) 2006-2008 Institute of Applied Mechanics, Technische Universität\n");
      printf("München. (http://www.amm.mw.tum.de)\n");
      printf("\n");
      printf("Licensed under the GPL (see file COPYING or option --license).\n");
      printf("\n");
      printf("This is free software; see the source for copying conditions. There is NO\n");
      printf("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n");
      printf("\n");
      printf("This program uses:\n");
      printf("- 'Qt' from http://www.trolltech.com (License: GPL)\n");
      printf("- 'libwave - Wavefront/GL rendering library' by Dave Pape from\n");
      printf("  http://www.evl.uic.edu/pape/sw/libwave.html (Licence: GPL)\n");
      printf("- 'GLE - Tubing and Extrusion Library' by Linas Vepstas from\n");
      printf("  http://linas.org/gle/ (Licence: GPL, Artistic)\n");
      printf("- 'Qwt - Qt Widgets for Technical Applications' from http://qwt.sourceforge.net\n");
      printf("  (Licence: Qwt License (LGPL))\n");
      printf("\n");
      printf("Usage: amvis [<options>] [<directory>]\n");
      printf("  -?|-h|--help   Show this help.\n");
      printf("  --mindocks     Start with minimized/closed docks.\n");
      printf("  --play         Play after start.\n");
      printf("  --speed=<x>    Set playing speed to <x>.\n");
      printf("  --view=<file>  Set initial view.\n");
      printf("  --wst=<file>   Restore window state from <file>\n");
      printf("  --license      Print GPL\n");
      printf("  <dir>          Change directory to <dir> before start.\n");
      printf("                 Use current directory if not given.\n");
      printf("\n");
      printf("Searches for the file '.amvis' in the following directories (in order):\n");
      printf("On UNIX:    <dir>, $HOME\n");
      printf("On Windows: <dir>, %%HOMEDRIVE%%%%HOMEPATH%%, %%USERPROFILE%%\n");
      return 0;
    }

    if(argc>1 && argv[argc-1][0]!='-')
      if(QDir::setCurrent(argv[argc-1])==false) {
        printf("Directory %s not found!\n",argv[argc-1]);
        printf("Trying current directory!\n");
      }


    // Read '.amvis'
    ifstream rc;
    rc.open(".amvis");
    if(rc.fail()) {
      char AMVIS[1000];
#if defined UNIX
      strcpy(AMVIS, getenv("HOME"));
      strcat(AMVIS, "/.amvis");
      rc.open(AMVIS);
#elif defined WINDOWS
      strcpy(AMVIS, getenv("HOMEDRIVE"));
      strcat(AMVIS, getenv("HOMEPATH"));
      strcat(AMVIS, "\\.amvis");
      rc.open(AMVIS);
      if(rc.fail()) {
        strcpy(AMVIS, getenv("USERPROFILE"));
        strcat(AMVIS, "\\.amvis");
        rc.open(AMVIS);
      }
#endif
    }
    if(!rc.fail()) {
      float EPS;
      rc>>EPS;
      CBody::setEPS(EPS);
      rc.close();
    }


    QApplication app(argc, argv);
    Q_INIT_RESOURCE(amvis);
    MainWindow mainWin(minDocks, wst, view, play, speed);
    mainWin.show();
    return app.exec();
}
