/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QDesktopWidget>
#include <QTimer>
#include <fstream>
#include <iostream>
#include <QDataStream>
#include <QFile>
#include <stdio.h>
#include <QListWidget>
#include <QStatusBar>
#include <QAbstractItemView>
#include <QtOpenGL>
#include <QSpinBox>
#include "GL/glu.h"
#include "GL/gl.h"
#include <QtGui>
#include <QtOpenGL>
#include "stdlib.h"
#include "glwidget.h"
#include <QSlider>
#include <QLabel>
#include <QGroupBox>
#include <QRadioButton>
#include <QCheckBox>
#include <QDir>
#include <QKeyEvent>
using namespace std;


class QAction;
class QLabel;
class QMenu;
class QScrollArea;
class QSlider;
class GLWidget;
class QPushButton;
class QTextEdit;
class QTimer;
class QListWidget;
class QStatusBar;
class QSpinBox;
class QSlider;
class QGroupBox ;
class QRadioButton;
class QKeyEvent;
class QCheckBox;
class QDockWidget;

class MainWindow : public QMainWindow
{
   Q_OBJECT

      public:
      MainWindow(bool minDocks, QString wst, QString viewFile, bool autoPlay=false, double animationSpeed=1.0);

   private slots:

  void help();
  void about();
  void set_window_title ( QString title);
  void cachePosFiles();
  void loadWindowState();
  void saveWindowState();
  void saveViewPortState();
  void loadViewPortState();
  void loadViewPortStateFile(QString filename);
 
private:
   void createActions();
   void createMenus();
   QSize getSize();
   QWidget *centralWidget;
   QPushButton *startvis;
   QTextEdit *output_edit;
   GLWidget *glWidget;
   QStatusBar * StatusBar;
   QSpinBox * FrameSpinBox;
   QSlider * FrameSlider;
   QSlider * TimeSlider;
   QLabel * TimeFrameLabel;
   QLabel * TimeSliderLabel;
   QLabel * TimeIntervalLabel;
   QCheckBox* EnabledCheckBox;
   QCheckBox* SelectedCheckBox;
   QCheckBox* ContourCheckBox;
   QCheckBox* PathCheckBox;
   QCheckBox* LocalCosCheckBox;
   QPushButton* Filled_Radio_Button;
   QPushButton* Line_Radio_Button;
   QPushButton* Points_Radio_Button;
   QDialog *helpDialog;
   QDockWidget *LeftInfoListDock;
   QDockWidget *AnimationDock;

   QPushButton * LocalCosButton;
   QListWidget *LeftInfoList;

   QDockWidget * ObjectPropertyBox;
   QMenu *fileMenu, *viewMenu;
   QMenu *helpMenu;
   bool timerisrunning;
   QAction *exitAct, *exportPNGAct, *exportSinglePNGAct, *cachePosFilesAct;
   QAction *aboutAct, *helpAct;
   QAction *aboutQtAct;
   int writeinfile;
   QTimer *filewritetimer ;
   ofstream outfilestream;
   QFile    qoutfilestream;
   FILE *f;
   FILE *fp;
};

#endif
