/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef OBJOBJECT_H
#define OBJOBJECT_H

#include "crigidbody.h" // inheriting class's header file
#include <wave.h>

// No description
class ObjObject : public CRigidBody
{
public:
   // class constructor
   ObjObject(char* body_name, char * pos_file);
   ObjObject(FILE *bodyfile);
   // class destructor
   ~ObjObject();
   // No description
   virtual void init();
   virtual void draw_contour();
   char* objfilename ;
   bool usetex, usemat;
   int normalFlag;
   wfObject *model;
   // No description
   virtual void draw_pure();
   virtual void draw();
private:
   wfObject *contourList;
   float epsVertex, epsNormal, epsAngle;
   int outline;
};

#endif // OBJOBJECT_H
