/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <path.h>
#include <GL/glu.h>

// Destructor
Path::Path(char* body_name, char *pos_file) : CBody(body_name, pos_file) {
  binaryrecordsize=sizeof(float)*4;
  int result;
  char* charstringline = new char [charlength];

  parsenextdataline(datafile);
  result=GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f %f" ,&r, &g, &b);

  delete[]charstringline;
}

// Destructor
Path::~Path() {
}

// Draw body
void Path::draw() {
  if(path.size()<=(unsigned long)curdataset) {
    for(int i=path.size(); i<=curdataset; i++) {
      update(i);
      Point3D *p=new Point3D;
      p->x=x;
      p->y=y;
      p->z=z;
      path.push_back(p);
    }
  }

  drawPath(r, g, b);
}

// Initialize (Call CBody::init()!)
void Path::init() {
  CBody::init();
}

// Read data from pos-file
void Path::update(long dataset_number) {
  fseek(posfile_pointer, dataset_number*recordsize, SEEK_SET);
  if(pos_file_binary==true) {
    float dummy[4];
    fread(dummy,sizeof(float),4,posfile_pointer);
    current_time=dummy[0];
    x=dummy[1];
    y=dummy[2];
    z=dummy[3];
  } else
    fscanf(posfile_pointer, "%f %f %f %f", &current_time, &x, &y, &z);
  curdataset=dataset_number;
}

// Text in the left
void Path::return_info_string(QString &info) {
  info=tr("Class: %1\nBody: %2\nPos-File: %3").arg(class_name).arg(body_file_name).arg(posfile_name);
}
