/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _PATH_H_
#define _PATH_H_

#include <cbody.h>
#include <vector>

class Path : public CBody
{
public:
   Path(char* body_name, char *pos_file);
   ~Path();

   // overloaded pure virtual-functions
   void draw();
   void init();
   void update(long dataset_number);
   void return_info_string(QString &info);

   void draw_pure() {};

protected:
   float r, g, b;

   float t, x, y, z;
   
};

#endif
