#
#   AMVis - 3D Multibody Visualisation Program.
#   Copyright (C) 2006 Institute of Applied Mechanics,
#                      Technical University of Munich
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

#! /bin/sh

if [ $# -ne 0 ]; then
cat << EOF
Usage: $0
Converts all mtl files in the current directory containing map_Kd tags to a
format known by libwave/AMVis.
This script makes modification in mtl and obj files and creates map files.
EOF
fi

i=0;
for MTL in *.mtl; do
  if grep -e "^[ 	]*map_Kd[ 	]" $MTL >& /dev/null; then
    MAP=convertmtl_${MTL%*.mtl}.map
    # Create map file
    sed -rne "/^[ 	]*newmtl[ 	]/s/^[ 	]*newmtl[ 	]+(.+)$/newmap convertmtl_\1/p;/^[ 	]*map_Kd[ 	]/s/^[ 	]*map_Kd[ 	]+(.*)$/Kd \1/p" $MTL > $MAP
    sed -re "/^newmap /h;/^newmap /d;/^Kd /H;/^Kd /g" $MAP > $MAP.new
    rm -f $MAP
    mv $MAP.new $MAP
    # Save map names
    MAPNAMES=$(sed -rne "/^[ 	]*newmap[ 	]/s/^[ 	]*newmap[ 	]+(.+)$/\1/p" $MAP)
    # Delete maps from mtl
    grep -ve "^[ 	]*map_Kd[ 	]" $MTL > $MTL.new
    rm -f $MTL
    mv $MTL.new $MTL
    # Add maps to obj
    for OBJ in *.obj; do
      # Add maplib
      sed -re "/^[ 	]*mtllib[ 	]+$MTL$/s/.*/mtllib $MTL\nmaplib $MAP/" $OBJ > $OBJ.new
      rm -f $OBJ
      mv $OBJ.new $OBJ
      # Add usemap
      for M in $MAPNAMES; do
        M=${M#convertmtl_*}
        sed -re "/^[ 	]*usemtl[ 	]+$M$/s/.*/usemtl $M\nusemap convertmtl_$M/" $OBJ > $OBJ.new
        rm -f $OBJ
        mv $OBJ.new $OBJ
      done
    done
  fi
done
