/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

enum bool {false, true};

#include <wave.h>
#include <string.h>

int main(int argc, char *argv[])
{
  if(argc!=7) {
    printf("Usage: %s <normalFlag> <epsVertex> <epsNormal>\n", argv[0]);
    printf("       <epsAngle> <outline> <objfile>\n");
    printf("\n");
    printf("See AMVis help for describtion.\n");
    return 0;
  }

  int normalFlag;
  float epsVertex, epsNormal, epsAngle;
  int outline;
  char *objfilename;

  sscanf(argv[1], "%d", &normalFlag);
  sscanf(argv[2], "%f", &epsVertex);
  sscanf(argv[3], "%f", &epsNormal);
  sscanf(argv[4], "%f", &epsAngle);
  sscanf(argv[5], "%d", &outline);
  objfilename=argv[6];

  wfObject *model;

  printf("Reading Obj-file '%s'\n", objfilename);
  model=wfReadObject(objfilename);
  if(epsVertex>0) {
    printf("Combine vertices\n");
    wfCombineVertices(model, epsVertex);
  }
  // normalFlag==0 use normals from obj-file
  if(normalFlag==1) {
    printf("Compute flat normals\n");
    wfComputeNormals(model,false,false);
  }
  else if(normalFlag==2) {
    printf("Compute smooth normals\n");
    wfComputeNormals(model,true,false);
  }
  else if(normalFlag==3) {
    printf("Compute real normals\n");
    wfComputeNormals2(model, epsAngle);
  }
  if(epsNormal>0 && normalFlag==0) {
    printf("Combine normals\n");
    wfCombineNormals(model, epsNormal);
  }

  char *objoutfilename=malloc(sizeof(char)*(strlen(objfilename)+20));
  strcpy(objoutfilename, objfilename);
  strrchr(objoutfilename, '.')[0]=0;
  strcat(objoutfilename, "_amvis.obj");

  if(outline==1) {
    printf("Compute outline\n");
    wfObject *contourList=wfGenOutline(model);
    char *outlineFile=(char*)malloc(sizeof(char)*strlen(objoutfilename)+80);
    strcpy(outlineFile, objoutfilename);
    strcpy(outlineFile+strlen(objoutfilename)-4,".outline.obj");
    printf("Writing outline to Obj-file '%s'\n", outlineFile);
    FILE*f=fopen(outlineFile,"w");
    wfWriteObject(f,contourList);
    fclose(f);
  }

  printf("Writing Obj-file '%s'\n", objoutfilename);
  FILE *file=fopen(objoutfilename, "w");
  wfWriteObject(file, model);
  fclose(file);

  return 0;
}
