/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "rotation.h"

using namespace std;

Rotation::Rotation(char* body_name, char * pos_file): CRigidBody( body_name,  pos_file), Contour_List(0)
{
  strcpy(body_file_name,body_name);
  strcpy(posfile_name , pos_file);

  parsenextdataline(datafile);
  Contour *dataset;
  
  float minmax[3];
  minmax[2]=0;
  do {
    dataset=new Contour;
    fscanf(datafile, "%f %f %d", &dataset->x, &dataset->y, &dataset->b);
    if(dataset->b==-1) break;
    contour.push_back(dataset);
    minmax[0]=dataset->x;
    minmax[1]=dataset->y;
    updateminmax(minmax);
  } while(1);
  minmax[0]=-x_min;
  updateminmax(minmax);
  minmax[0]=-x_max;
  updateminmax(minmax);
  minmax[2]=x_max;
  updateminmax(minmax);
  minmax[2]=-x_max;
  updateminmax(minmax);

  contour=recalcContour(contour);
}

Rotation::Rotation(FILE *bodyfile): CRigidBody(bodyfile), Contour_List(0)
{
  parsenextdataline(datafile);
  Contour *dataset;
  
  float minmax[3];
  minmax[2]=0;
  do {
    dataset=new Contour;
    fscanf(datafile, "%f %f %d", &dataset->x, &dataset->y, &dataset->b);
    if(dataset->b==-1) break;
    contour.push_back(dataset);
    minmax[0]=dataset->x;
    minmax[1]=dataset->y;
    updateminmax(minmax);
  } while(1);
  minmax[0]=-x_min;
  updateminmax(minmax);
  minmax[0]=-x_max;
  updateminmax(minmax);
  minmax[2]=x_max;
  updateminmax(minmax);
  minmax[2]=-x_max;
  updateminmax(minmax);
}

Rotation::~Rotation()
{
}

void Rotation::init()
{
  CRigidBody::init();

  float r=0;
  for(int i=0; i<(int)contour.size(); i++) {
    r=fmax(r,contour[i]->x);
  }
  int N=NCIRCLE(r);

  if (Displ_List) glDeleteLists(Displ_List, 1);
  Displ_List=glGenLists(1);
  glNewList(Displ_List, GL_COMPILE);
    int i, j, k, l;
    for(j=0; j<(int)contour.size(); j++) {
      i=j-1;
      if(i<0) i+=contour.size();
      k=j+1;
      if(k>=(int)contour.size()) k-=contour.size();
      l=k+1;
      if(l>=(int)contour.size()) l-=contour.size();

      //Normal j in x-y-Ebene
      float njx, njy;
      if(contour[j]->b==0) {
         njx=contour[k]->y-contour[i]->y;
         njy=contour[i]->x-contour[k]->x;
      } else {
         njx=contour[k]->y-contour[j]->y;
         njy=contour[j]->x-contour[k]->x;
      }
      //Normal k in x-y-Ebene
      float nkx, nky;
      if(contour[k]->b==0) {
         nkx=contour[l]->y-contour[j]->y;
         nky=contour[j]->x-contour[l]->x;
      } else {
         nkx=contour[k]->y-contour[j]->y;
         nky=contour[j]->x-contour[k]->x;
      }

      int m, n;
      for(m=0; m<N; m++) {
        float alpham=2.0*M_PI/N*m;
        n=m+1;
        if(n>=N) n=0;
        float alphan=2.0*M_PI/N*n;
        glBegin(GL_QUADS);
          glNormal3f(njx*cos(alpham), njy, njx*sin(alpham));
          glVertex3f(contour[j]->x*cos(alpham), contour[j]->y, contour[j]->x*sin(alpham));
          glNormal3f(nkx*cos(alpham), nky, nkx*sin(alpham));
          glVertex3f(contour[k]->x*cos(alpham), contour[k]->y, contour[k]->x*sin(alpham));
          glNormal3f(nkx*cos(alphan), nky, nkx*sin(alphan));
          glVertex3f(contour[k]->x*cos(alphan), contour[k]->y, contour[k]->x*sin(alphan));
          glNormal3f(njx*cos(alphan), njy, njx*sin(alphan));
          glVertex3f(contour[j]->x*cos(alphan), contour[j]->y, contour[j]->x*sin(alphan));
        glEnd();
      }
    }
  glEndList();

  if(Contour_List) glDeleteLists(Contour_List, 1);
  Contour_List=glGenLists(1);
  glNewList(Contour_List, GL_COMPILE);
    glDisable(GL_LINE_SMOOTH);
    glEnable(GL_COLOR_MATERIAL);
    glLineWidth(1.0);
    glDisable(GL_LIGHTING);
    glColor3f(0.0, 0.0, 0.0);
    vector<Contour*>::iterator u;
    for(u=contour.begin(); u!=contour.end(); u++) {
      if((*u)->b==1) {
        glBegin(GL_LINE_LOOP);
        for(int i=0; i<N; i++) {
          float alpha=2.0*M_PI/N*i;
          glVertex3f((*u)->x*cos(alpha), (*u)->y, (*u)->x*sin(alpha));
        }
        glEnd();
      }
    }
  glEndList();
}

void Rotation::draw_contour()
{
  glCallList(Contour_List);
}
