#include <simplematvec.h>

vec vav(vec a, vec b) {
  vec c;
  for(int i=0; i<=3; i++)
    c.e[i]=a.e[i]+b.e[i];
  return c;
}

vec vsv(vec a, vec b) {
  vec r;
  for(int i=0; i<=3; i++)
    r.e[i]=a.e[i]-b.e[i];
  return r;
}

vec mmv(mat A, vec b) {
  vec r;
  for(int i=0; i<=3; i++) {
    r.e[i]=0;
    for(int j=0; j<=3; j++)
      r.e[i]+=A.e[i][j]*b.e[j];
  }
  return r;
}

mat mmm(mat A, mat B) {
  mat R;
  for(int i=0; i<=3; i++)
    for(int j=0; j<=3; j++) {
      R.e[i][j]=0;
      for(int k=0; k<=3; k++)
        R.e[i][j]+=A.e[i][k]*B.e[k][j];
    }
  return R;
}

mat mtrans(mat A) {
  mat R;
  for(int i=0; i<=3; i++)
    for(int j=0; j<=3; j++)
      R.e[j][i]=A.e[i][j];
  return R;
}

vec tovec(float *a) {
  vec r;
  for(int i=0; i<=3; i++)
    r.e[i]=a[i];
  return r;
}

mat tomat(float *A) {
  mat R;
  for(int i=0; i<=3; i++)
    for(int j=0; j<=3; j++)
      R.e[i][j]=A[4*j+i];
  return R;
}

void vecto(vec a, float *r) {
  for(int i=0; i<=3; i++)
    r[i]=a.e[i];
}

void matto(mat A, float *R) {
  for(int i=0; i<=3; i++)
    for(int j=0; j<=3; j++)
      R[4*j+i]=A.e[i][j];
}
