/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "sphere.h" // class's header file

// class constructor
Sphere::Sphere(char* body_name, char * pos_file): CRigidBody( body_name,  pos_file)
{
   strcpy(body_file_name,body_name);
   strcpy(posfile_name , pos_file);
   int result;
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&SphereSize);
}

Sphere::Sphere(FILE *bodyfile): CRigidBody(bodyfile)
{
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&SphereSize);
}

Sphere::~Sphere()
{
}

void Sphere::init()
{
   CRigidBody::init();



   float minmax[3];
   minmax[0] = SphereSize ;
   minmax[1] = 0.0;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = -SphereSize ;
   minmax[1] = 0.0;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0 ;
   minmax[1] = SphereSize;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0 ;
   minmax[1] = -SphereSize;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0 ;
   minmax[1] = 0.0;
   minmax[2] = SphereSize;
   updateminmax(minmax) ;
   minmax[0] = 0.0 ;
   minmax[1] = 0.0 ;
   minmax[2] = -SphereSize;
   updateminmax(minmax) ;

   if (Displ_List) glDeleteLists(Displ_List, 1);
   Displ_List = glGenLists(1);
   glNewList(Displ_List, GL_COMPILE);
   // Draw Sphere BEGIN
   static GLUquadricObj *quadObj = gluNewQuadric();
   gluQuadricDrawStyle(quadObj, GLU_FILL);
   gluQuadricNormals(quadObj, GLU_SMOOTH);
   int N=NCIRCLE(SphereSize);
   gluSphere(quadObj, SphereSize, N, N/2);
   // Draw Sphere END
   glEndList();

}

void Sphere::draw_contour()
{
//    glEnable(GL_POLYGON_OFFSET_LINE);
//    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
//    glEnable(GL_COLOR_MATERIAL);
//    glLineWidth(1.0);
//    glPolygonOffset(-1.0,0.0);
//    glDisable(GL_LIGHTING);
//    glEnable(GL_LINE_SMOOTH);
//    glColor3f(0.0, 0.0, 0.0);
//    glCallList(Displ_List);
//    glPolygonOffset(1.0,0.0);
//    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
//    glDisable(GL_POLYGON_OFFSET_LINE);
}
