/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <testelasticbody.h>

// Destructor
TestElasticBody::TestElasticBody(char* body_name, char *pos_file) : CBody(body_name, pos_file) {
  binaryrecordsize=sizeof(float)*3;
  depth=0;
  posx=0;
  int result;
  char* charstringline = new char [charlength];

  parsenextdataline(datafile);
  result=GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f" ,&width);

  parsenextdataline(datafile);
  result=GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f" ,&height);
}

// Destructor
TestElasticBody::~TestElasticBody() {
}

void TestElasticBody::drawBody() {
  glBegin(GL_QUADS);
    glNormal3f(0, 0, 1);
    glVertex3f(0, 0, 0);
    glVertex3f(width, 0, 0);
    glVertex3f(width, height, 0);
    glVertex3f(0, height, 0);
    glNormal3f(0, 0, 1);
    glVertex3f(0, 0, depth);
    glVertex3f(width, 0, depth);
    glVertex3f(width, height, depth);
    glVertex3f(0, height, depth);
    glNormal3f(0, -1, 0);
    glVertex3f(0, 0, 0);
    glVertex3f(width, 0, 0);
    glVertex3f(width, 0, depth);
    glVertex3f(0, 0, depth);
    glNormal3f(0, -1, 0);
    glVertex3f(0, height, 0);
    glVertex3f(width, height, 0);
    glVertex3f(width, height, depth);
    glVertex3f(0, height, depth);
    glNormal3f(1, 0, 0);
    glVertex3f(0, 0, 0);
    glVertex3f(0, height, 0);
    glVertex3f(0, height, depth);
    glVertex3f(0, 0, depth);
    glNormal3f(1, 0, 0);
    glVertex3f(width, 0, 0);
    glVertex3f(width, height, 0);
    glVertex3f(width, height, depth);
    glVertex3f(width, 0, depth);
  glEnd();
}

// Draw body
void TestElasticBody::draw() {
  glDisable(GL_COLOR_MATERIAL);
  glEnable(GL_LIGHTING);
  GLfloat color[] = {0.0, 0.0, 1.0, 1.0 };
  glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, color);
  GLfloat mat_specular[] = {1.0, 1.0, 1.0, 1.0};
  glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, mat_specular);
  float color_shininess=20;
  glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, &color_shininess);
  float em[4]={0,0,0,0};
  glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, em);

  glPushMatrix();
  glTranslatef(posx, 0, 0);

  if(mode==0) glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  if(mode==1) glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
  if(mode==2) glPolygonMode(GL_FRONT_AND_BACK, GL_POINT);

  drawBodyFast(); // this calls "virtual void drawBody()" in a very fast way if possible!
  
  if(contour_flag==true) {
    // draw contour
    glEnable(GL_POLYGON_OFFSET_LINE);
    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
    glEnable(GL_COLOR_MATERIAL);
    glLineWidth(1.0);
    glPolygonOffset(OFFSETFAC1,OFFSETUNIT1);
    glDisable(GL_LIGHTING);
    glEnable(GL_LINE_SMOOTH);
    glColor3f(0.0, 0.0, 0.0);
    drawBodyFast(); // this calls "virtual void drawBody()" in a very fast way if possible!
    glPolygonOffset(0.0,0.0);
  }
  
  if(selected_flag==true) {
    // draw something
  }
  
  if(local_cos_flag==true) {
    // draw something
  }

  glPopMatrix();

  if(path_flag) {
    long drawpathto=curdataset;
    if(path.size()<=(unsigned long)drawpathto) {
      for(int i=path.size(); i<=drawpathto; i++) {
        update(i);
        Point3D *p=new Point3D;
        p->x=posx;
        p->y=0;
        p->z=0;
        path.push_back(p);
      }
    }
    drawPath(0, 1, 0);
  }
}

// Initialize (Call CBody::init()!)
void TestElasticBody::init() {
  CBody::init();
}

// Read data from pos-file
void TestElasticBody::update(long dataset_number) {
  fseek(posfile_pointer, dataset_number*recordsize, SEEK_SET);
  if(pos_file_binary==true) {
    float dummy[3];
    fread(dummy,sizeof(float),3,posfile_pointer);
    current_time=dummy[0];
    posx=dummy[1];
    depth=dummy[2];
  } else
    fscanf(posfile_pointer, "%f %f %f", &current_time, &posx, &depth);
  curdataset=dataset_number;
}

// For selection by mouse click
void TestElasticBody::draw_pure() {
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  glDisable(GL_LIGHTING);
  glEnable(GL_COLOR_MATERIAL);
  glColor3fv(pick_color_value);
  glPushMatrix();
  glTranslatef(posx, 0, 0);

  drawBodyFast(); // this calls "virtual void drawBody()" in a very fast way if possible!

  glPopMatrix();
  glEnable(GL_LIGHTING);
  glDisable(GL_COLOR_MATERIAL);
}

// Text in the left
void TestElasticBody::return_info_string(QString &info) {
  info=tr("Class: %1\nBody: %2\nPos-File: %3\nWidth: %4\nHeight: %5").arg(class_name).arg(body_file_name).arg(posfile_name).arg(width).arg(height);
}

// For move camera with body (rigid-body movement)
void TestElasticBody::ret_rot(float *rotation) {
  rotation[0]=0;
  rotation[1]=0;
  rotation[2]=0;
}

// For move camera with body (rigid-body movement)
void TestElasticBody::ret_trans(float *translation) {
  translation[0]=posx;
  translation[1]=0;
  translation[2]=0;
}

// For move camera with body (rigid-body movement) (Not really needed)
void TestElasticBody::return_max_dimensions(float *min_x, float *max_x, float *min_y, float *max_y, float *min_z, float *max_z) {
  *min_x=0;
  *max_x=width;
  *min_y=0;
  *max_y=height;
  *min_z=0;
  *max_z=depth;
}
