/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _TESTELASTICBODY_H_
#define _TESTELASTICBODY_H_

#include <cbody.h>

class TestElasticBody : public CBody
{
public:
   TestElasticBody(char* body_name, char *pos_file);
   ~TestElasticBody();

   void drawBody();

   // overloaded pure virtual-functions
   void draw();
   void init();
   void update(long dataset_number);
   void draw_pure();
   void return_info_string(QString &info);

   // overloaded virtual-functions; only needed for 'Move Camera With Body'
   void ret_rot(float *rotation);
   void ret_trans(float *translation);
   void return_max_dimensions(float *min_x, float *max_x, float *min_y, float *max_y, float *min_z, float *max_z);

protected:
   float width, height, depth, posx;
};

#endif
