/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "torus.h" // class's header file

// class constructor
Torus::Torus(char* body_name, char * pos_file): CRigidBody( body_name,  pos_file)
{
   strcpy(body_file_name,body_name);
   strcpy(posfile_name , pos_file);
   int result;
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&inner_radius);
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&outer_radius);

}

Torus::Torus(FILE *bodyfile): CRigidBody(bodyfile)
{
   int result;
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&inner_radius);
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&outer_radius);

}

Torus::~Torus()
{
}

void Torus::init()
{
   CRigidBody::init();
   float minmax[3];
   minmax[0] = outer_radius +(outer_radius -inner_radius) / 2.0 ;
   minmax[1] = 0.0;
   minmax[2] = (outer_radius -inner_radius) / 2.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0 ;
   minmax[1] = outer_radius+(outer_radius -inner_radius) / 2.0;
   minmax[2] = (outer_radius -inner_radius) / 2.0;
   updateminmax(minmax) ;
   minmax[0] = -outer_radius -(outer_radius -inner_radius) / 2.0;
   minmax[1] = 0.0;
   minmax[2] = (outer_radius -inner_radius) / 2.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0 ;
   minmax[1] = -outer_radius-(outer_radius -inner_radius) / 2.0;
   minmax[2] = (outer_radius -inner_radius) / 2.0;
   updateminmax(minmax) ;
   minmax[0] = outer_radius +(outer_radius -inner_radius) / 2.0 ;
   minmax[1] = 0.0;
   minmax[2] = -(outer_radius -inner_radius) / 2.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0 ;
   minmax[1] = outer_radius+(outer_radius -inner_radius) / 2.0;
   minmax[2] = -(outer_radius -inner_radius) / 2.0;
   updateminmax(minmax) ;
   minmax[0] = -outer_radius-(outer_radius -inner_radius) / 2.0 ;
   minmax[1] = 0.0;
   minmax[2] = -(outer_radius -inner_radius) / 2.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0 ;
   minmax[1] = -outer_radius-(outer_radius -inner_radius) / 2.0;
   minmax[2] = -(outer_radius -inner_radius) / 2.0;
   updateminmax(minmax) ;
   if (Displ_List) glDeleteLists(Displ_List, 1);
   Displ_List = glGenLists(1);
   glNewList(Displ_List, GL_COMPILE);
   // Draw Torus BEGIN
   int i, j;
   GLfloat theta, phi, theta1;
   GLfloat cosTheta, sinTheta;
   GLfloat cosTheta1, sinTheta1;
   GLfloat ringDelta, sideDelta;
   int Ns=NCIRCLE(inner_radius);
   int Nr=NCIRCLE(outer_radius+inner_radius);
   ringDelta = 2.0 * M_PI / Nr;
   sideDelta = 2.0 * M_PI / Ns;
   theta = 0.0;
   cosTheta = 1.0;
   sinTheta = 0.0;
   for (i = Nr - 1; i >= 0; i--) {
      theta1 = theta + ringDelta;
      cosTheta1 = cos(theta1);
      sinTheta1 = sin(theta1);
      glBegin(GL_QUAD_STRIP);
      phi = 0.0;
      for (j = Ns; j >= 0; j--) {
         GLfloat cosPhi, sinPhi, dist;
         phi += sideDelta;
         cosPhi = cos(phi);
         sinPhi = sin(phi);
         dist = outer_radius + inner_radius * cosPhi;
         glNormal3f(cosTheta1 * cosPhi, -sinTheta1 * cosPhi, sinPhi);
         glVertex3f(cosTheta1 * dist, -sinTheta1 * dist, inner_radius * sinPhi);
         glNormal3f(cosTheta * cosPhi, -sinTheta * cosPhi, sinPhi);
         glVertex3f(cosTheta * dist, -sinTheta * dist, inner_radius * sinPhi);
      }
      glEnd();
      theta = theta1;
      cosTheta = cosTheta1;
      sinTheta = sinTheta1;
   }
   // Draw Torus END
   glEndList();

}

void Torus::draw_contour()
{
//    glEnable(GL_POLYGON_OFFSET_LINE);
//    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
//    glEnable(GL_COLOR_MATERIAL);
//    glLineWidth(1.0);
//    glPolygonOffset(-1.0,0.0);
//    glDisable(GL_LIGHTING);
//    glEnable(GL_LINE_SMOOTH);
//    glColor3f(0.0, 0.0, 0.0);
//    glCallList(Displ_List);
//    glPolygonOffset(1.0,0.0);
//    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
//    glDisable(GL_POLYGON_OFFSET_LINE);
}
