/*
   AMVis - 3D Multibody Visualisation Program.
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technische Universitaet Muenchen

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <GL/gl.h>
#include "vt_rockerarm.h" // class's header file

// class constructor
VT_RockerArm::VT_RockerArm(char* body_name, char * pos_file): CRigidBody( body_name,  pos_file)
{
  strcpy(body_file_name,body_name);
  strcpy(posfile_name , pos_file);
  int result;
  char* charstringline = new char [charlength];

  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f \n", &ACD[0][0], &ACD[0][1]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n", &Racd[0]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f \n", &winkel0[0], &winkel[0]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f \n", &ACD[1][0], &ACD[1][1]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n", &Racd[1]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f \n", &winkel0[1], &winkel[1]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f \n", &ACD[2][0], &ACD[2][1]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n", &Racd[2]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f \n", &winkel0[2], &winkel[2]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n", &r);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n", &fBreite);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%i \n", &FlagSideFrame);
  quadObj=gluNewQuadric();
  gluQuadricDrawStyle(quadObj, GLU_FILL);
}

VT_RockerArm::VT_RockerArm(FILE *bodyfile): CRigidBody(bodyfile)
{
  char* charstringline = new char [charlength];
  int result;
  
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f \n", &ACD[0][0], &ACD[0][1]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n", &Racd[0]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f \n", &winkel0[0], &winkel[0]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f \n", &ACD[1][0], &ACD[1][1]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n", &Racd[1]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f \n", &winkel0[1], &winkel[1]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f \n", &ACD[2][0], &ACD[2][1]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n", &Racd[2]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f %f \n", &winkel0[2], &winkel[2]);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n", &r);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n", &fBreite);
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%i \n", &FlagSideFrame);
  quadObj=gluNewQuadric();
  gluQuadricDrawStyle(quadObj, GLU_FILL);
}

VT_RockerArm::~VT_RockerArm()
{
  gluDeleteQuadric(quadObj);
}

void VT_RockerArm::drawBody() {
  //=== Funktionsflächen                                ==============================
  for(int iFF=0; iFF<3; iFF++) {
    if ((winkel[iFF]!=0)&&(Racd[iFF]!=0)){
      glTranslatef(ACD[iFF][0], ACD[iFF][1], 0.0);
      fStep = (winkel[iFF]) / Nacd[iFF];
      glBegin(GL_QUADS);
      glNormal3f(sin(winkel0[iFF]), cos(winkel0[iFF]), 0.0);
      glVertex3f(Racd[iFF] * cos(winkel0[iFF]), Racd[iFF] * sin(winkel0[iFF]), hBr);
      glVertex3f((Racd[iFF]+fDicke) * cos(winkel0[iFF]), (Racd[iFF]+fDicke) * sin(winkel0[iFF]), hBr);
      glVertex3f((Racd[iFF]+fDicke) * cos(winkel0[iFF]), (Racd[iFF]+fDicke) * sin(winkel0[iFF]), -hBr);
      glVertex3f(Racd[iFF] * cos(winkel0[iFF]), Racd[iFF] * sin(winkel0[iFF]), -hBr);
      glNormal3f(sin((winkel0[iFF] + winkel[iFF])), cos((winkel0[iFF] + winkel[iFF])), 0.0);
      glVertex3f(Racd[iFF] * cos((winkel0[iFF] + winkel[iFF])), Racd[iFF] * sin((winkel0[iFF] + winkel[iFF])), hBr);
      glVertex3f((Racd[iFF]+fDicke) * cos((winkel0[iFF] + winkel[iFF])), (Racd[iFF]+fDicke) * sin((winkel0[iFF] + winkel[iFF])), hBr);
      glVertex3f((Racd[iFF]+fDicke) * cos((winkel0[iFF] + winkel[iFF])), (Racd[iFF]+fDicke) * sin((winkel0[iFF] + winkel[iFF])), -hBr);
      glVertex3f(Racd[iFF] * cos((winkel0[iFF] + winkel[iFF])), Racd[iFF] * sin((winkel0[iFF] + winkel[iFF])), -hBr);
      for(i = winkel0[iFF]; i < (winkel[iFF] + winkel0[iFF]); i+=fStep)
      {
	u = cos(i);
	v = sin(i);

	vert[0][0] = Racd[iFF] * u;
	vert[0][1] = Racd[iFF] * v;
	vert[0][2] = hBr;

	vert[1][0] = Racd[iFF] * u;
	vert[1][1] = Racd[iFF] * v;
	vert[1][2] = -hBr;

	verta[0][0] = (Racd[iFF] + fDicke) * u;
	verta[0][1] = (Racd[iFF] + fDicke) * v;
	verta[0][2] = hBr;

	verta[1][0] = (Racd[iFF] + fDicke) * u;
	verta[1][1] = (Racd[iFF] + fDicke) * v;
	verta[1][2] = -hBr;

	u = cos(i + fStep);
	v = sin(i + fStep);

	vert[2][0] = Racd[iFF] * u;
	vert[2][1] = Racd[iFF] * v;
	vert[2][2] = -hBr;

	verta[2][0] = (Racd[iFF] + fDicke) * u;
	verta[2][1] = (Racd[iFF] + fDicke) * v;
	verta[2][2] = -hBr;

	calcNormal(vert, normal);
	glNormal3f(normal[0], normal[1], normal[2]);

	glVertex3f(vert[0][0], vert[0][1], vert[0][2]);
	glVertex3f(vert[1][0], vert[1][1], vert[1][2]);
	glVertex3f(vert[2][0], vert[2][1], vert[2][2]);
	glVertex3f(vert[2][0], vert[2][1], hBr);

	glVertex3f(verta[0][0], verta[0][1], verta[0][2]);
	glVertex3f(verta[1][0], verta[1][1], verta[1][2]);
	glVertex3f(verta[2][0], verta[2][1], verta[2][2]);
	glVertex3f(verta[2][0], verta[2][1], hBr);

      } 
      glEnd();
      if ((FlagSideFrame==2)||(FlagSideFrame==0)) {
	glTranslatef(0.0, 0.0, hBr);
	gluPartialDisk(quadObj, Racd[iFF], Racd[iFF] + fDicke, Nacd[iFF], 4, 90.0 - (winkel[iFF] + winkel0[iFF])/RAD, winkel[iFF]/RAD);
	glTranslatef(0.0, 0.0, -hBr);
      }
      if ((FlagSideFrame==1)||(FlagSideFrame==0)) {
	glTranslatef(0.0, 0.0, -hBr);
	gluPartialDisk(quadObj, Racd[iFF], Racd[iFF] + fDicke, Nacd[iFF], 4, 90.0 - (winkel[iFF] + winkel0[iFF])/RAD, winkel[iFF]/RAD);
	glTranslatef(0.0, 0.0, hBr);
      }
      glTranslatef(-ACD[iFF][0], -ACD[iFF][1], 0.0);

    }
  }

  // Verbindungsrahmen zw. den Funktionsflächen

  if ((FlagSideFrame==1)||(FlagSideFrame==3)) {

    glBegin(GL_TRIANGLE_FAN);				// Deckflaeche 1 (positive Richtung)
    glNormal3f(0.0, 0.0, -1.0);
    glVertex3f(0.0, 0.0, fBreite / 2.0);
    glVertex3f(RMN[0][0], RMN[0][1], hBr); 
    glVertex3f(RMN[1][0], RMN[1][1], hBr);
    glVertex3f(RMN[2][0], RMN[2][1], hBr);
    glVertex3f(RMN[3][0], RMN[3][1], hBr);
    glVertex3f(RMN[4][0], RMN[4][1], hBr);
    glVertex3f(RMN[5][0], RMN[5][1], hBr);
    glVertex3f(RMN[6][0], RMN[6][1], hBr);
    glVertex3f(RMN[7][0], RMN[7][1], hBr);
    glVertex3f(RMN[8][0], RMN[8][1], hBr);
    glVertex3f(RMN[9][0], RMN[9][1], hBr);
    glVertex3f(RMN[0][0], RMN[0][1], hBr);
    glEnd(); 

    glBegin(GL_TRIANGLE_FAN);				// Bodenflaeche 1
    glNormal3f(0.0, 0.0, -1.0);
    glVertex3f(0.0, 0.0, hBr + fDicke);
    glVertex3f(RMN[0][0], RMN[0][1], hBr + fDicke);
    glVertex3f(RMN[1][0], RMN[1][1], hBr + fDicke);
    glVertex3f(RMN[2][0], RMN[2][1], hBr + fDicke);
    glVertex3f(RMN[3][0], RMN[3][1], hBr + fDicke);
    glVertex3f(RMN[4][0], RMN[4][1], hBr + fDicke);
    glVertex3f(RMN[5][0], RMN[5][1], hBr + fDicke);
    glVertex3f(RMN[6][0], RMN[6][1], hBr + fDicke);
    glVertex3f(RMN[7][0], RMN[7][1], hBr + fDicke);
    glVertex3f(RMN[8][0], RMN[8][1], hBr + fDicke);
    glVertex3f(RMN[9][0], RMN[9][1], hBr + fDicke);
    glVertex3f(RMN[0][0], RMN[0][1], hBr + fDicke);
    glEnd();

    glBegin(GL_QUADS);						// Berandung 1
    glNormal3f(0.0, -1.0, 0.0);
    glVertex3f(RMN[0][0], RMN[0][1], hBr);
    glVertex3f(RMN[0][0], RMN[0][1], hBr + fDicke);
    glVertex3f(RMN[9][0], RMN[9][1], hBr + fDicke);
    glVertex3f(RMN[9][0], RMN[9][1], hBr);
    ang = atan((ACD[0][1] - RMN[1][1]) / (ACD[0][0] - RMN[0][0]));
    glNormal3f(-sin(ang), -cos(ang), 0.0);
    glVertex3f(RMN[1][0], RMN[1][1], hBr);
    glVertex3f(RMN[1][0], RMN[1][1], hBr + fDicke);
    glVertex3f(RMN[0][0], RMN[0][1], hBr + fDicke);
    glVertex3f(RMN[0][0], RMN[0][1], hBr);
    ang = atan((RMN[2][1] - RMN[1][1]) / (RMN[2][0] - RMN[1][0]));
    glNormal3f(-sin(ang), -cos(ang), 0.0);
    glVertex3f(RMN[2][0], RMN[2][1], hBr);
    glVertex3f(RMN[2][0], RMN[2][1], hBr + fDicke);
    glVertex3f(RMN[1][0], RMN[1][1], hBr + fDicke);
    glVertex3f(RMN[1][0], RMN[1][1], hBr);
    glNormal3f(-1.0, 0.0, 0.0);
    glVertex3f(RMN[3][0], RMN[3][1], hBr);
    glVertex3f(RMN[3][0], RMN[3][1], hBr + fDicke);
    glVertex3f(RMN[2][0], RMN[2][1], hBr + fDicke);
    glVertex3f(RMN[2][0], RMN[2][1], hBr);
    glNormal3f(0.0, 1.0, 0.0);
    glVertex3f(RMN[4][0], RMN[4][1], hBr);
    glVertex3f(RMN[4][0], RMN[4][1], hBr + fDicke);
    glVertex3f(RMN[3][0], RMN[3][1], hBr + fDicke);
    glVertex3f(RMN[3][0], RMN[3][1], hBr);
    ang = atan((RMN[5][1] - RMN[4][1]) / (RMN[4][0] - RMN[5][0]));
    glNormal3f(-sin(ang), cos(ang), 0.0);
    glVertex3f(RMN[5][0], RMN[5][1], hBr);
    glVertex3f(RMN[5][0], RMN[5][1], hBr + fDicke);
    glVertex3f(RMN[4][0], RMN[4][1], hBr + fDicke);
    glVertex3f(RMN[4][0], RMN[4][1], hBr);
    glNormal3f(0.0, 1.0, 0.0);
    glVertex3f(RMN[6][0], RMN[6][1], hBr);
    glVertex3f(RMN[6][0], RMN[6][1], hBr + fDicke);
    glVertex3f(RMN[5][0], RMN[5][1], hBr + fDicke);
    glVertex3f(RMN[5][0], RMN[5][1], hBr);
    glNormal3f(1.0, 0.0, 0.0);
    glVertex3f(RMN[7][0], RMN[7][1], hBr);
    glVertex3f(RMN[7][0], RMN[7][1], hBr + fDicke);
    glVertex3f(RMN[6][0], RMN[6][1], hBr + fDicke);
    glVertex3f(RMN[6][0], RMN[6][1], hBr);
    ang = atan((RMN[8][1] - RMN[7][1]) / (RMN[8][0] - RMN[7][0]));
    glNormal3f(-sin(ang), -cos(ang), 0.0);
    glVertex3f(RMN[8][0], RMN[8][1], hBr);
    glVertex3f(RMN[8][0], RMN[8][1], hBr + fDicke);
    glVertex3f(RMN[7][0], RMN[7][1], hBr + fDicke);
    glVertex3f(RMN[7][0], RMN[7][1], hBr);
    ang = atan((RMN[9][1] - RMN[8][1]) / (RMN[9][0] - RMN[8][0]));
    glNormal3f(-sin(ang), -cos(ang), 0.0);
    glVertex3f(RMN[9][0], RMN[9][1], hBr);
    glVertex3f(RMN[9][0], RMN[9][1], hBr + fDicke);
    glVertex3f(RMN[8][0], RMN[8][1], hBr + fDicke);
    glVertex3f(RMN[8][0], RMN[8][1], hBr);
    glEnd();
  }


  if ((FlagSideFrame==2)||(FlagSideFrame==3)) {

    glBegin(GL_TRIANGLE_FAN);				// Deckflaeche 2 (negative Richtung)
    glNormal3f(0.0, 0.0, -1.0);
    glVertex3f(0.0, 0.0, -hBr - fDicke);
    glVertex3f(RMN[0][0], RMN[0][1], -hBr - fDicke);
    glVertex3f(RMN[1][0], RMN[1][1], -hBr - fDicke);
    glVertex3f(RMN[2][0], RMN[2][1], -hBr - fDicke);
    glVertex3f(RMN[3][0], RMN[3][1], -hBr - fDicke);
    glVertex3f(RMN[4][0], RMN[4][1], -hBr - fDicke);
    glVertex3f(RMN[5][0], RMN[5][1], -hBr - fDicke);
    glVertex3f(RMN[6][0], RMN[6][1], -hBr - fDicke);
    glVertex3f(RMN[7][0], RMN[7][1], -hBr - fDicke);
    glVertex3f(RMN[8][0], RMN[8][1], -hBr - fDicke);
    glVertex3f(RMN[9][0], RMN[9][1], -hBr - fDicke);
    glVertex3f(RMN[0][0], RMN[0][1], -hBr - fDicke);
    glEnd(); 

    glBegin(GL_TRIANGLE_FAN);				// Bodenflaeche 2
    glNormal3f(0.0, 0.0, 1.0);
    glVertex3f(0.0, 0.0, -hBr);
    glVertex3f(RMN[0][0], RMN[0][1], -hBr );
    glVertex3f(RMN[1][0], RMN[1][1], -hBr );
    glVertex3f(RMN[2][0], RMN[2][1], -hBr );
    glVertex3f(RMN[3][0], RMN[3][1], -hBr );
    glVertex3f(RMN[4][0], RMN[4][1], -hBr );
    glVertex3f(RMN[5][0], RMN[5][1], -hBr );
    glVertex3f(RMN[6][0], RMN[6][1], -hBr );
    glVertex3f(RMN[7][0], RMN[7][1], -hBr );
    glVertex3f(RMN[8][0], RMN[8][1], -hBr );
    glVertex3f(RMN[9][0], RMN[9][1], -hBr );
    glVertex3f(RMN[0][0], RMN[0][1], -hBr );
    glEnd();

    glBegin(GL_QUADS);						// Berandung 2
    glNormal3f(0.0, 1.0, 0.0);
    glVertex3f(RMN[0][0], RMN[0][1], -hBr);
    glVertex3f(RMN[0][0], RMN[0][1], -hBr - fDicke);
    glVertex3f(RMN[9][0], RMN[9][1], -hBr - fDicke);
    glVertex3f(RMN[9][0], RMN[9][1], -hBr);
    ang = atan((ACD[0][1] - RMN[1][1]) / (ACD[0][0] - RMN[0][0]));
    glNormal3f(sin(ang), cos(ang), 0.0);
    glVertex3f(RMN[1][0], RMN[1][1], -hBr);
    glVertex3f(RMN[1][0], RMN[1][1], -hBr - fDicke);
    glVertex3f(RMN[0][0], RMN[0][1], -hBr - fDicke);
    glVertex3f(RMN[0][0], RMN[0][1], -hBr);
    ang = atan((RMN[2][1] - RMN[1][1]) / (RMN[2][0] - RMN[1][0]));
    glNormal3f(sin(ang), cos(ang), 0.0);
    glVertex3f(RMN[2][0], RMN[2][1], -hBr);
    glVertex3f(RMN[2][0], RMN[2][1], -hBr - fDicke);
    glVertex3f(RMN[1][0], RMN[1][1], -hBr - fDicke);
    glVertex3f(RMN[1][0], RMN[1][1], -hBr);
    glNormal3f(1.0, 0.0, 0.0);
    glVertex3f(RMN[3][0], RMN[3][1], -hBr);
    glVertex3f(RMN[3][0], RMN[3][1], -hBr - fDicke);
    glVertex3f(RMN[2][0], RMN[2][1], -hBr - fDicke);
    glVertex3f(RMN[2][0], RMN[2][1], -hBr);
    glNormal3f(0.0, -1.0, 0.0);
    glVertex3f(RMN[4][0], RMN[4][1], -hBr);
    glVertex3f(RMN[4][0], RMN[4][1], -hBr - fDicke);
    glVertex3f(RMN[3][0], RMN[3][1], -hBr - fDicke);
    glVertex3f(RMN[3][0], RMN[3][1], -hBr);
    ang = atan((RMN[5][1] - RMN[4][1]) / (RMN[4][0] - RMN[5][0]));
    glNormal3f(sin(ang), -cos(ang), 0.0);
    glVertex3f(RMN[5][0], RMN[5][1], -hBr);
    glVertex3f(RMN[5][0], RMN[5][1], -hBr - fDicke);
    glVertex3f(RMN[4][0], RMN[4][1], -hBr - fDicke);
    glVertex3f(RMN[4][0], RMN[4][1], -hBr);
    glNormal3f(0.0, -1.0, 0.0);
    glVertex3f(RMN[6][0], RMN[6][1], -hBr);
    glVertex3f(RMN[6][0], RMN[6][1], -hBr - fDicke);
    glVertex3f(RMN[5][0], RMN[5][1], -hBr - fDicke);
    glVertex3f(RMN[5][0], RMN[5][1], -hBr);
    glNormal3f(-1.0, 0.0, 0.0);
    glVertex3f(RMN[7][0], RMN[7][1], -hBr);
    glVertex3f(RMN[7][0], RMN[7][1], -hBr - fDicke);
    glVertex3f(RMN[6][0], RMN[6][1], -hBr - fDicke);
    glVertex3f(RMN[6][0], RMN[6][1], -hBr);
    ang = atan((RMN[8][1] - RMN[7][1]) / (RMN[8][0] - RMN[7][0]));
    glNormal3f(sin(ang), cos(ang), 0.0);
    glVertex3f(RMN[8][0], RMN[8][1], -hBr);
    glVertex3f(RMN[8][0], RMN[8][1], -hBr - fDicke);
    glVertex3f(RMN[7][0], RMN[7][1], -hBr - fDicke);
    glVertex3f(RMN[7][0], RMN[7][1], -hBr);
    ang = atan((RMN[9][1] - RMN[8][1]) / (RMN[9][0] - RMN[8][0]));
    glNormal3f(sin(ang), cos(ang), 0.0);
    glVertex3f(RMN[9][0], RMN[9][1], -hBr);
    glVertex3f(RMN[9][0], RMN[9][1], -hBr - fDicke);
    glVertex3f(RMN[8][0], RMN[8][1], -hBr - fDicke);
    glVertex3f(RMN[8][0], RMN[8][1], -hBr);
    glEnd(); 
  }
  glEnd(); 
  glTranslatef(0.0, 0.0, -hBr);
  gluCylinder(quadObj, r, r, fBreite, NCIRCLE(r), 3);
  if ((FlagSideFrame==1)||(FlagSideFrame==0)) {
    gluDisk(quadObj, 0.0, r, NCIRCLE(r), 3);
  }
  if ((FlagSideFrame==2)||(FlagSideFrame==0)) {
    glTranslatef(0.0, 0.0, fBreite);
    gluDisk(quadObj, 0.0, r, NCIRCLE(r), 3);
  }


  min_x = RMN[6][0];
  max_x = RMN[2][0];

  if(RMN[5][1] < RMN[4][1])
    minf = RMN[5][1];
  else if(RMN[5][1] > RMN[4][1])
    minf = RMN[4][1];
  if(RMN[0][1] > RMN[1][1] && RMN[0][1] > RMN[8][1])
    maxf = RMN[0][1];
  else if(RMN[1][1] > RMN[0][1] && RMN[1][1] > RMN[8][1])
    maxf = RMN[1][1];
  else if(RMN[8][1] > RMN[0][1] && RMN[8][1] > RMN[1][1])
    maxf = RMN[8][1];
  minmax[0] = max_x;
  minmax[1] = minf;
  minmax[2] = hBr + fDicke;
  updateminmax(minmax);
  minmax[0] = min_x;
  minmax[1] = maxf;
  minmax[2] = -hBr - fDicke;
  updateminmax(minmax);
}

void VT_RockerArm::init()
{
  hBr = fBreite / 2.0;
  for (int iFF=0; iFF<3; iFF++) {
    Nacd[iFF] = (int)(NCIRCLE(Racd[iFF]) * (winkel[iFF] / 360.0));
    winkel[iFF] = winkel[iFF]*RAD;
    winkel0[iFF] = winkel0[iFF]*RAD;
  }
  fDicke = fBreite*0.2;
  Racd[0] -= fDicke;
  contour_flag = false;

  int IndexCD=1;
  double Winkel_A, Winkel_CD;

  if(ACD[0][0] > ACD[1][0] && ACD[0][0] > ACD[2][0]) {         	// A befindet sich RECHTS von C und D
    if (fabs(ACD[1][0]+ Racd[1]*cos(winkel0[1]+winkel[1])) < fabs(ACD[2][0]+ Racd[2]*cos(winkel0[2]+winkel[2]))) 
      if ((Racd[2]!=0)&&(winkel[2]!=0)) IndexCD= 2;		// ACD[IndexCD] ist massgebend fuer Aussenkontur
  }
  else {
    if (fabs(ACD[1][0]+ Racd[1]*cos(winkel0[1])) < fabs(ACD[2][0]+ Racd[2]*cos(winkel0[2]))) 
      if ((Racd[2]!=0)&&(winkel[2]!=0)) IndexCD= 2;		// ACD[IndexCD] ist massgebend fuer Aussenkontur
  }
  if(ACD[0][0] > ACD[1][0] && ACD[0][0] > ACD[2][0]) {         	// A befindet sich RECHTS von C und D
    Winkel_A = winkel0[0]       + winkel[0]       + 0.175;
    Winkel_CD= winkel0[IndexCD] + winkel[IndexCD] + 0.175;
  }
  else if(ACD[0][0] < ACD[1][0] && ACD[0][0] < ACD[2][0]) {   	// A befindet sich LINKS von C und D
    Winkel_A = winkel0[0]       - 0.175;
    Winkel_CD= winkel0[IndexCD] - 0.175;
  }
  else 								// A befindet sich zwischen C und D => Fehlermeldung
  {
    printf("\nFehler: Geometrie falsch!\n");
    exit(1);
  }

  RMN[0][0] = 0.3 * ACD[0][0];
  RMN[0][1] = 2.0 * r;

  double Rtmp;
  Rtmp = Racd[0]-6.0*fDicke;
  if (Rtmp<0) Rtmp = Racd[0]-fDicke;
  RMN[1][0] = ACD[0][0] + Rtmp * cos((winkel0[0] + 0.5 * winkel[0]));
  RMN[1][1] = ACD[0][1] + Rtmp * sin((winkel0[0] + 0.5 * winkel[0]));

  RMN[2][0] = ACD[0][0] + (Racd[0] + 0.5 * fDicke) * cos(Winkel_A);
  RMN[2][1] = ACD[0][1] - Racd[0] + 1.5*fDicke;

  RMN[3][0] = RMN[2][0];
  RMN[3][1] = ACD[0][1] - Racd[0] - 1.5*fDicke;

  RMN[4][0] = 0.5 * ACD[0][0];
  RMN[4][1] = RMN[3][1];

  RMN[5][0] = 0.5 * ACD[IndexCD][0];
  RMN[5][1] = -1.5*fDicke + ACD[IndexCD][1];

  RMN[6][0] = ACD[IndexCD][0] + (Racd[IndexCD] + 2.0 * fDicke) * cos(Winkel_CD);
  RMN[6][1] = RMN[5][1];

  RMN[7][0] = RMN[6][0];
  RMN[7][1] = RMN[6][1] + 4.0 * fDicke;

  RMN[8][0] = ACD[IndexCD][0] ;//+ (Racd[IndexCD] + 3.0 * fDicke) * cos(2.1);
  RMN[8][1] = ACD[IndexCD][1] + (Racd[IndexCD] + 3.0 * fDicke) * 1;//sin(2.1);

  RMN[9][0] = 0.3 * ACD[IndexCD][0];
  RMN[9][1] = 2.0 * r;

  if(ACD[0][0] < ACD[1][0] && ACD[0][0] < ACD[2][0]) {   	// A befindet sich LINKS von C und D
    GLfloat RMNtmp[10][2];
    for (int ii=0; ii<10; ii++) {
      RMNtmp[ii][0] = RMN[ii][0]; 
      RMNtmp[ii][1] = RMN[ii][1];
    }
    for (int ii=0; ii<10; ii++) {
      RMN[ii][0] = RMNtmp[9-ii][0]; 
      RMN[ii][1] = RMNtmp[9-ii][1];
    }
  }

  CRigidBody::init();

  if (Displ_List) glDeleteLists(Displ_List, 1);
  Displ_List = glGenLists(1);
  glNewList(Displ_List, GL_COMPILE);
  // Draw RockerArm BEGIN
//  glPushMatrix();
  drawBody();
//  glPopMatrix();
  // Draw RockerArm END
  glEndList();
}


void VT_RockerArm::draw_contour()
{
  glEnable(GL_POLYGON_OFFSET_LINE);
  glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
  glEnable(GL_COLOR_MATERIAL);
  glLineWidth(1.0);
  glPolygonOffset(OFFSETFAC1,OFFSETUNIT1);
  glDisable(GL_LIGHTING);
  glEnable(GL_LINE_SMOOTH);
  
  glColor3f(0.0, 0.0, 0.0);
  //glCallList(Displ_List);
  glPolygonOffset(0.0,0.0);
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  glDisable(GL_POLYGON_OFFSET_LINE);
}
