/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ROCKERARM_H
#define ROCKERARM_H

#include <QMessageBox>
#include "crigidbody.h" // inheriting class's header file

class VT_RockerArm : public CRigidBody
{
public:
   // class constructor
   VT_RockerArm(char* body_name, char * pos_file);
   VT_RockerArm(FILE *bodyfile);
   // class destructor
   ~VT_RockerArm();
   virtual void init();
   void drawBody();
   virtual void draw_contour();
   
   GLfloat ACD[3][2];    // Koordinaten zur Festlegung der Funktionsflaechen (Punkte A, C und D)
   GLfloat winkel0[3];   // Winkel zur Festlegung der Funktionsflächen: alpha0, gamma0 und delta0
   GLfloat winkel[3];    // alpha, gamma, delta
   GLfloat Racd[3];      // Radien der Funktionsflaechen: Ra, Rc, Rd
   GLfloat RMN[10][2];   // Punkte mit 2 Koordinaten zur Festlegung, 3 Koordinate const. 

   GLfloat r; // Radius für den jeweiligen Punkt und Zylinder
   GLfloat fBreite, hBr; // Breite der Funktionsflächen
   GLfloat fDicke; // Dicke = Außenradius - Innenradius
   GLfloat i, u, v, ang, minf, maxf, min_x, max_x; // Hilfsvariablen für die Schleifen
   GLfloat minmax[3];
   static const GLfloat RAD = M_PI / 180.0;// Const. Umrechnungsfaktor Grad in Rad
   GLint Nacd[3]; 	// Diskretisierung der Funktionsflächen
   GLint FlagSideFrame;		// {0,1,2,3} : no, pos., neg or both side frames are drawn
   GLfloat fStep;
   // Vertex-Information für die Funktionsflächen
   GLfloat vert[3][3];
   // Vertex-Information für die Außenflächen
   GLfloat verta[3][3];
   GLfloat normal[3];

   GLUquadricObj *quadObj;
};

#endif // ROCKERARM_H
