/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "vt_valve.h" // class's header file

// class constructor
VT_Valve::VT_Valve(char* body_name, char * pos_file): CRigidBody( body_name,  pos_file)
{
   strcpy(body_file_name,body_name);
   strcpy(posfile_name , pos_file);
   int result;
   char* charstringline = new char [charlength];
   
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&r);

   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&h);

   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&R);

   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&R_sk);
   
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&R_sg);

   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&L_sk);

   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&L_sg);

   quadObj = gluNewQuadric();
   gluQuadricDrawStyle(quadObj, GLU_FILL);
}

VT_Valve::VT_Valve(FILE *bodyfile): CRigidBody(bodyfile)
{
   int result;
   char* charstringline = new char [charlength];
   
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&r);

   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&h);

   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&R);
   
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&R_sk);
   
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&R_sg);

   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&L_sk);

   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&L_sg);

   quadObj = gluNewQuadric();
   gluQuadricDrawStyle(quadObj, GLU_FILL);
}

VT_Valve::~VT_Valve()
{
   gluDeleteQuadric(quadObj);
}

void VT_Valve::drawBody()
{
   fStep = 2.0 * r * sin(phi * M_PI / 180.0) / N_kr;
   delta = L_sg - L_sk;
   L_cyl = L_sk - (R_sk - 2.0 * r) * tan((90.0 - phi) * M_PI / 180.0) - 2 * r * sin(phi * M_PI / 180.0);
   gluDisk(quadObj, 0.0, r, NCIRCLE(r), 1);
   glTranslatef(0.0, 0.0, h - 0.3 * r);
   gluDisk(quadObj, 0.0, R, NCIRCLE(R), 1);
   gluCylinder(quadObj, R, R, 0.3 * r, NCIRCLE(R), 1);
   glTranslatef(0.0, 0.0, 0.3 * r);
   gluDisk(quadObj, 0.0, R, NCIRCLE(R), 1);
   glTranslatef(0.0, 0.0, -h);
   gluCylinder(quadObj, r, r, L_cyl, NCIRCLE(r), 1);
   glTranslatef(0.0, 0.0, L_cyl);
   ra = r;
   for(int i = 1; i <= N_kr; i++)
   {
      theta = asin(i * fStep / (2.0 * r));
      if(i!=1)
         ra = rb;
      rb = r * (3.0 - 2.0 * cos(theta));
      gluCylinder(quadObj, ra, rb, fStep, NCIRCLE(ra), 1);
      glTranslatef(0.0, 0.0, fStep);
   }
   gluCylinder(quadObj, r*(3.0-2.0*cos(theta)), R_sk, (R_sk - 2.0 * r) * tan((90.0 - phi) * M_PI / 180.0), NCIRCLE(r*(3.0-2.0*cos(theta))), 1);
   glTranslatef(0.0, 0.0, (R_sk - 2.0 * r) * tan((90.0 - phi) * M_PI / 180.0));
   gluCylinder(quadObj, R_sk, R_sg, delta, NCIRCLE(R_sk), 1); // VT_Valvesitz (Funktionsflche)
   glTranslatef(0.0, 0.0, delta);
   gluCylinder(quadObj, R_sg, R_sg, delta * 0.2, NCIRCLE(R_sg), 1);
   glTranslatef(0.0, 0.0, delta * 0.2);
   gluDisk(quadObj, 0.85 * R_sk, R_sg, NCIRCLE(.85*R_sk), 1);
   glTranslatef(0.0, 0.0, -delta * 0.2);
   gluCylinder(quadObj, 0.85 * R_sk, 0.85 * R_sk, delta * 0.2, NCIRCLE(.85*R_sk), 1);
   glTranslatef(0.0, 0.0, -delta * 0.7);
   gluCylinder(quadObj, 0.0, 0.85 * R_sk, delta * 0.7, NCIRCLE(.85*R_sk), 1);
}

void VT_Valve::init()
{
   CRigidBody::init();
   float minmax[3];

   minmax[0] = R_sg;
   minmax[1] = 0.0;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0;
   minmax[1] = R_sg;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = 0.0;
   minmax[1] = -R_sg;
   minmax[2] = 0.0;
   updateminmax(minmax); 
   minmax[0] = -R_sg;
   minmax[1] = 0.0;
   minmax[2] = 0.0;
   updateminmax(minmax) ;
   minmax[0] = R_sg;
   minmax[1] = 0.0;
   minmax[2] = 1.2 * L_sg - 0.2 * L_sk;
   updateminmax(minmax) ;
   minmax[0] = 0.0;
   minmax[1] = R_sg;
   minmax[2] = 1.2 * L_sg - 0.2 * L_sk;
   updateminmax(minmax) ;
   minmax[0] = 0.0;
   minmax[1] = -R_sg;
   minmax[2] = 1.2 * L_sg - 0.2 * L_sk;
   updateminmax(minmax); 
   minmax[0] = -R_sg;
   minmax[1] = 0.0;
   minmax[2] = 1.2 * L_sg - 0.2 * L_sk;
   updateminmax(minmax);

   if (Displ_List) glDeleteLists(Displ_List, 1);
   Displ_List = glGenLists(1);
   glNewList(Displ_List, GL_COMPILE);
   N_kr = (int)(NCIRCLE(r) / 8);
   glPushMatrix();
   // Anfang vom Zeichnen
   phi = 72.0;
   drawBody();
   // Ende vom Zeichnen
   glPopMatrix();
   glEndList();

}

void VT_Valve::draw_contour()
{/*
   glEnable(GL_POLYGON_OFFSET_LINE);
   glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEnable(GL_COLOR_MATERIAL);
   glLineWidth(1.0);
   glPolygonOffset(OFFSETFAC1,OFFSETUNIT1);
   glDisable(GL_LIGHTING);
   glEnable(GL_LINE_SMOOTH);
   glColor3f(0.0, 0.0, 0.0);
   Circle_Line(top);
   glPushMatrix();
   glTranslatef(0.0, 0.0, -height);
   Circle_Line(base);
   glPopMatrix();

   glPolygonOffset(0.0,0.0);
   glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
   glDisable(GL_POLYGON_OFFSET_LINE);*/
}
