/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef VALVE_H
#define VALVE_H

#include <QMessageBox>
#include "crigidbody.h" // inheriting class's header file

class VT_Valve : public CRigidBody
{
public:
   // class constructor
   VT_Valve(char* body_name, char * pos_file);
   VT_Valve(FILE *bodyfile);
   // class destructor
   ~VT_Valve();
   virtual void init();
   virtual void draw_contour();
   void drawBody();
   float r, h, R;
   float R_sk, R_sg; // Kleiner und großer Radius des Ventilsitzes.
   float L_sk, L_sg; // Stelle, wo die Funktionsfläche beginnt und endet.

protected: // Variablen für Schleifen, Hilfsvariablen usw.
   float L_cyl;
   float ra, rb;
   int N_kr;
   float theta;
   float fStep;
   float phi, a, delta;
   GLUquadricObj *quadObj;
};

#endif // VALVE_H
