/*
   AMVis - 3D Multibody Visualisation Program.
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technische Universitaet Muenchen

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <GL/gl.h>
#include "vt_valveseat.h" // class's header file

// class constructor
VT_ValveSeat::VT_ValveSeat(char* body_name, char * pos_file): CRigidBody( body_name,  pos_file)
{
  strcpy(body_file_name,body_name);
  strcpy(posfile_name , pos_file);
  int result;
  char* charstringline = new char [charlength];

  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&Rsk);

  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&Rsg);

  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&l);

  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&h);

  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&R);

  quadObj = gluNewQuadric();
  gluQuadricDrawStyle(quadObj, GLU_FILL);
  quadObj1 = gluNewQuadric();
  gluQuadricDrawStyle(quadObj1, GLU_FILL);
}

VT_ValveSeat::VT_ValveSeat(FILE *bodyfile): CRigidBody(bodyfile)
{
  int result;
  char* charstringline = new char [charlength];
  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&Rsk);

  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&Rsg);

  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&l);

  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&h);

  parsenextdataline(datafile);
  result = GetCharacterLine(charstringline, charlength, datafile);
  sscanf(charstringline, "%f \n" ,&R);

  quadObj = gluNewQuadric();
  gluQuadricDrawStyle(quadObj, GLU_FILL);
  quadObj1 = gluNewQuadric();
  gluQuadricDrawStyle(quadObj1, GLU_FILL);
}

VT_ValveSeat::~VT_ValveSeat()
{
  gluDeleteQuadric(quadObj);
  gluDeleteQuadric(quadObj1);
}

  void VT_ValveSeat::drawBody() {
    if ((Rsg-Rsk)!=0)
      alpha = atan((h-l)/(Rsg-Rsk));
    else alpha =M_PI/2.0;
    fStep = M_PI / N;
    if(tan(alpha)==0)
      exit(1);
    p = (h - l) / tan(alpha);
    if(p > R - Rsk)
    {
      printf("\nParameter inkorrekt, Phase zu groß.");
      exit(1);
    }
    glBegin(GL_QUADS);
    for(phi = 0.0; phi < M_PI; phi+=fStep)
    {
      u = sin(phi);
      v = cos(phi);

      vert[0][0] = -Rsk * u;
      vert[0][1] = -Rsk * v;
      ver[0][0] = -R * u;
      ver[0][1] = -R * v;
      vert[2][0] = -(Rsk + p) * u;
      vert[2][1] = -(Rsk + p) * v;

      u = sin(phi + fStep);
      v = cos(phi + fStep);

      vert[1][0] = -Rsk * u;
      vert[1][1] = -Rsk * v;
      ver[1][0] = -R * u;
      ver[1][1] = -R * v;
      vert[3][0] = -(Rsk + p) * u;
      vert[3][1] = -(Rsk + p) * v;

      vn[0][0] = vert[1][0];
      vn[0][1] = vert[1][1];
      vn[0][2] = 0.0;

      vn[1][0] = vert[0][0];
      vn[1][1] = vert[0][1];
      vn[1][2] = 0.0;

      vn[2][0] = vert[0][0];
      vn[2][1] = vert[0][1];
      vn[2][2] = l;

      vn1[0][0] = vert[1][0];
      vn1[0][1] = vert[1][1];
      vn1[0][2] = l;

      vn1[1][0] = vert[0][0];
      vn1[1][1] = vert[0][1];
      vn1[1][2] = l;

      vn1[2][0] = vert[3][0];
      vn1[2][1] = vert[3][1];
      vn1[2][2] = h;

      calcNormal(vn, normal);
      glNormal3f(normal[0], normal[1], normal[2]);

      // Zeichnen Innenfläche mit Phase
      glVertex3f(vert[0][0], vert[0][1], 0.0f);
      glVertex3f(vert[0][0], vert[0][1], l);
      glVertex3f(vert[1][0], vert[1][1], l);
      glVertex3f(vert[1][0], vert[1][1], 0.0f);

      calcNormal(vn1, normal);
      glNormal3f(normal[0], normal[1], normal[2]);

      glVertex3f(vert[0][0], vert[0][1], l);
      glVertex3f(vert[2][0], vert[2][1], h);
      glVertex3f(vert[3][0], vert[3][1], h);
      glVertex3f(vert[1][0], vert[1][1], l);

      // Zeichnen Außenfläche		
      glVertex3f(ver[0][0], ver[0][1], 0.0f);
      glVertex3f(ver[0][0], ver[0][1], h);
      glVertex3f(ver[1][0], ver[1][1], h);
      glVertex3f(ver[1][0], ver[1][1], 0.0f);
    }
    glEnd();
    // Schnittflächen:
    glBegin(GL_POLYGON);
    glNormal3f(1.0, 0.0, 0.0);
    glVertex3f(0.0, -Rsk, 0.0);
    glVertex3f(0.0, -Rsk, l);
    glVertex3f(0.0, -(Rsk + p), h);
    glVertex3f(0.0, -R, h);
    glVertex3f(0.0, -R, 0.0);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3f(-1.0, 0.0, 0.0);
    glVertex3f(0.0, Rsk, 0.0);
    glVertex3f(0.0, Rsk, l);
    glVertex3f(0.0, Rsk + p, h);
    glVertex3f(0.0, R, h);
    glVertex3f(0.0, R, 0.0);
    glEnd();
  }
void VT_ValveSeat::init()
{
  CRigidBody::init();
  float minmax[3];

  minmax[0] = R;
  minmax[1] = 0.0;
  minmax[2] = 0.0;
  updateminmax(minmax) ;
  minmax[0] = 0.0;
  minmax[1] = R;
  minmax[2] = 0.0;
  updateminmax(minmax) ;
  minmax[0] = 0.0;
  minmax[1] = -R;
  minmax[2] = 0.0;
  updateminmax(minmax); 
  minmax[0] = -R;
  minmax[1] = 0.0;
  minmax[2] = 0.0;
  updateminmax(minmax);
  minmax[0] = R;
  minmax[1] = 0.0;
  minmax[2] = h;
  updateminmax(minmax) ;
  minmax[0] = 0.0;
  minmax[1] = R;
  minmax[2] = h;
  updateminmax(minmax) ;
  minmax[0] = 0.0;
  minmax[1] = -R;
  minmax[2] = h;
  updateminmax(minmax); 
  minmax[0] = -R;
  minmax[1] = 0.0;
  minmax[2] = h;
  updateminmax(minmax);

  if (Displ_List) glDeleteLists(Displ_List, 1);
  Displ_List = glGenLists(1);
  glNewList(Displ_List, GL_COMPILE);
  N = NCIRCLE(R);
  glPushMatrix();
  gluQuadricOrientation(quadObj, GLU_INSIDE);	
  gluPartialDisk(quadObj, Rsk, R, N, 2, 180.0, 180.0);
  drawBody();
  glTranslatef(0.0, 0.0, h);
  gluQuadricOrientation(quadObj, GLU_OUTSIDE);
  gluPartialDisk(quadObj1, Rsk + p, R, N, 2, 180.0, 180.0);

  glPopMatrix();
  glEndList();

}

void VT_ValveSeat::draw_contour()
{/*
    glEnable(GL_POLYGON_OFFSET_LINE);
    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
    glEnable(GL_COLOR_MATERIAL);
    glLineWidth(1.0);
    glPolygonOffset(OFFSETFAC1,OFFSETUNIT1);
    glDisable(GL_LIGHTING);
    glEnable(GL_LINE_SMOOTH);
    glColor3f(0.0, 0.0, 0.0);
    Circle_Line(Rsk);
    Circle_Line(R);
    glPushMatrix();
    glTranslatef(0.0, 0.0, l);
    Circle_Line(Rsk);
    glTranslatef(0.0, 0.0, h - l);
    Circle_Line(Rsk + p);
    Circle_Line(R);
    glPopMatrix();

    glPolygonOffset(0.0,0.0);
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
    glDisable(GL_POLYGON_OFFSET_LINE);*/
}
