function AMVisPathPos(name,instance,data,append)
% Usage: AMVisPathPos(name,instance,data[,append])
%   WARNING! Only ascii pos-files can be wrote.
%   name:     Name of the pos-file (without .XXXX.pos)
%   instance: The instance of the pos-file (XXXX)
%   data:     [t x y z]
%             t, x, y, and z: Vectors of size N x 1
%   append:   If set to 'a', append data to pos-file else create/replace

  if size(data,2)~=4
    error('The parameter data must have 4 columns');
  end

  mode='wt';
  if exist('append','var')
    if append=='a'
      mode='at';
    end
  end

  file=fopen([name '.' num2str(instance,'%04d') '.pos'],mode);
    fprintf(file, '%13.5e %13.5e %13.5e %13.5e\n', data');
  fclose(file);
