function AMVisRotation(name,instances,inittrans,initrot,scale,varargin)
% Usage: AMVisRotation(name,instances,inittrans,initrot,scale,contour,...)
%   name:        Name of the body-file (without .body)
%   instances:   Number of instances of pos-files
%                Writes a bodyenv if zero or negativ
%   inittrans:   Initial translation [x y z]
%   initrot:     Initial rotation [alpha beta gamma]
%   scale:       Scale factor
%   contour:     Contour points [x y edge]; x,y,edge: Vectors of size N x 1
%   ...:         More contours

  file=AMVisCRigidBody(name,'Rotation',instances,inittrans,initrot,scale);
  for i=8-7:nargin-7
    fprintf(file, '%13.5e %13.5e %d\n', varargin{i}');
    fprintf(file, '0 0 -2\n');
  end
  fprintf(file, '0 0 -1\n');
  fclose(file);
